/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.DrainBarrier;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestDrainBarrier {
    @Test
    public void testBeginEndStopWork() throws Exception {
        DrainBarrier barrier = new DrainBarrier();
        Assert.assertTrue((boolean)barrier.beginOp());
        Assert.assertTrue((boolean)barrier.beginOp());
        barrier.endOp();
        barrier.endOp();
        barrier.stopAndDrainOps();
        Assert.assertFalse((boolean)barrier.beginOp());
    }

    @Test
    public void testUnmatchedEndAssert() throws Exception {
        DrainBarrier barrier = new DrainBarrier();
        try {
            barrier.endOp();
            Assert.fail((String)"Should have asserted");
        }
        catch (AssertionError e) {
            // empty catch block
        }
        barrier.beginOp();
        barrier.beginOp();
        barrier.endOp();
        barrier.endOp();
        try {
            barrier.endOp();
            Assert.fail((String)"Should have asserted");
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @Test
    public void testStopWithoutOpsDoesntBlock() throws Exception {
        DrainBarrier barrier = new DrainBarrier();
        barrier.stopAndDrainOpsOnce();
        barrier = new DrainBarrier();
        barrier.beginOp();
        barrier.endOp();
        barrier.stopAndDrainOpsOnce();
    }

    @Test
    public void testStopIsBlockedByOps() throws Exception {
        final DrainBarrier barrier = new DrainBarrier();
        barrier.beginOp();
        barrier.beginOp();
        barrier.beginOp();
        barrier.endOp();
        Thread stoppingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    barrier.stopAndDrainOpsOnce();
                }
                catch (InterruptedException e) {
                    Assert.fail((String)"Should not have happened");
                }
            }
        });
        stoppingThread.start();
        barrier.endOp();
        stoppingThread.join(1000L);
        Assert.assertTrue((boolean)stoppingThread.isAlive());
        barrier.endOp();
        stoppingThread.join(30000L);
        Assert.assertFalse((boolean)stoppingThread.isAlive());
    }

    @Test
    public void testMultipleStopOnceAssert() throws Exception {
        DrainBarrier barrier = new DrainBarrier();
        barrier.stopAndDrainOpsOnce();
        try {
            barrier.stopAndDrainOpsOnce();
            Assert.fail((String)"Should have asserted");
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @Test
    public void testMultipleSloppyStopsHaveNoEffect() throws Exception {
        DrainBarrier barrier = new DrainBarrier();
        barrier.stopAndDrainOps();
        barrier.stopAndDrainOps();
    }
}

