/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class WordStandardDeviation
extends Configured
implements Tool {
    private double stddev = 0.0;
    private static final Text LENGTH = new Text("length");
    private static final Text SQUARE = new Text("square");
    private static final Text COUNT = new Text("count");
    private static final LongWritable ONE = new LongWritable(1L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double readAndCalcStdDev(Path path, Configuration conf) throws IOException {
        Path file;
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!fs.exists(file = new Path(path, "part-r-00000"))) {
            throw new IOException("Output not found!");
        }
        double stddev = 0.0;
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)fs.open(file), Charsets.UTF_8));
            long count = 0L;
            long length = 0L;
            long square = 0L;
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                String type = st.nextToken();
                if (type.equals(COUNT.toString())) {
                    String countLit = st.nextToken();
                    count = Long.parseLong(countLit);
                    continue;
                }
                if (type.equals(LENGTH.toString())) {
                    String lengthLit = st.nextToken();
                    length = Long.parseLong(lengthLit);
                    continue;
                }
                if (!type.equals(SQUARE.toString())) continue;
                String squareLit = st.nextToken();
                square = Long.parseLong(squareLit);
            }
            double mean = (double)length / (double)count;
            mean = Math.pow(mean, 2.0);
            double term = (double)square / (double)count;
            stddev = Math.sqrt(term - mean);
            System.out.println("The standard deviation is: " + stddev);
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return stddev;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new WordStandardDeviation(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: wordstddev <in> <out>");
            return 0;
        }
        Configuration conf = this.getConf();
        Job job = new Job(conf, "word stddev");
        job.setJarByClass(WordStandardDeviation.class);
        job.setMapperClass(WordStandardDeviationMapper.class);
        job.setCombinerClass(WordStandardDeviationReducer.class);
        job.setReducerClass(WordStandardDeviationReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(args[0]));
        Path outputpath = new Path(args[1]);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputpath);
        boolean result = job.waitForCompletion(true);
        this.stddev = this.readAndCalcStdDev(outputpath, conf);
        return result ? 0 : 1;
    }

    public double getStandardDeviation() {
        return this.stddev;
    }

    public static class WordStandardDeviationReducer
    extends Reducer<Text, LongWritable, Text, LongWritable> {
        private LongWritable val = new LongWritable();

        public void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (LongWritable value : values) {
                sum = (int)((long)sum + value.get());
            }
            this.val.set((long)sum);
            context.write((Object)key, (Object)this.val);
        }
    }

    public static class WordStandardDeviationMapper
    extends Mapper<Object, Text, Text, LongWritable> {
        private LongWritable wordLen = new LongWritable();
        private LongWritable wordLenSq = new LongWritable();

        public void map(Object key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            StringTokenizer itr = new StringTokenizer(value.toString());
            while (itr.hasMoreTokens()) {
                String string = itr.nextToken();
                this.wordLen.set((long)string.length());
                this.wordLenSq.set((long)Math.pow(string.length(), 2.0));
                context.write((Object)LENGTH, (Object)this.wordLen);
                context.write((Object)SQUARE, (Object)this.wordLenSq);
                context.write((Object)COUNT, (Object)ONE);
            }
        }
    }
}

