/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

public class CauseFinder {
    private static final int START_INDEX = 0;

    public static int indexOfCause(Throwable parent, Class<? extends Throwable> causeClass, boolean isSubtypeOk) {
        return CauseFinder.indexOfCause(parent, causeClass, 0, isSubtypeOk);
    }

    private static int indexOfCause(Throwable parent, Class<? extends Throwable> causeClass, int cindex, boolean isSubtypeOk) {
        int resultIndex = cindex;
        Throwable cause = parent.getCause();
        if (cause != null && !CauseFinder.isMatching(cause, causeClass, isSubtypeOk)) {
            resultIndex = CauseFinder.indexOfCause(cause, causeClass, cindex + 1, isSubtypeOk);
        } else if (cause != null && CauseFinder.isMatching(cause, causeClass, isSubtypeOk)) {
            resultIndex = cindex != -1 ? cindex + 1 : cindex;
        } else if (cause == null) {
            resultIndex = -1;
        }
        return resultIndex;
    }

    private static boolean isMatching(Throwable cause, Class<? extends Throwable> causeClass, boolean isSubtypeOk) {
        return isSubtypeOk ? causeClass.isInstance(cause) : causeClass == cause.getClass();
    }

    public static Throwable getRootCause(Throwable parent) {
        return CauseFinder.getRootCause(parent, 0);
    }

    private static Throwable getRootCause(Throwable parent, int depth) {
        if (depth == 0 && parent == null) {
            throw new IllegalArgumentException("Given parent Throwable is null.");
        }
        Throwable theCause = parent.getCause();
        if (theCause != null) {
            return CauseFinder.getRootCause(theCause, depth + 1);
        }
        return parent;
    }

    public static Throwable causeAt(Throwable parent, int requiredIndex) {
        if (parent != null && requiredIndex > 0) {
            return CauseFinder.causeAt(parent.getCause(), requiredIndex - 1);
        }
        if (requiredIndex > 0) {
            return null;
        }
        return parent;
    }

    public static Throwable causeByType(Throwable parent, Class<? extends Throwable> causeType, boolean isSubtypeOk) {
        Throwable cause = null;
        int foundAtIndex = CauseFinder.indexOfCause(parent, causeType, isSubtypeOk);
        if (foundAtIndex != -1) {
            cause = CauseFinder.causeAt(parent, foundAtIndex);
        }
        return cause;
    }
}

