/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.functions.DestroyAsyncEventQueueFunction;
import org.apache.geode.management.internal.cli.functions.DestroyAsyncEventQueueFunctionArgs;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DestroyAsyncEventQueueCommand
extends GfshCommand {
    public static final String DESTROY_ASYNC_EVENT_QUEUE = "destroy async-event-queue";
    public static final String DESTROY_ASYNC_EVENT_QUEUE__HELP = "destroy an Async Event Queue";
    public static final String DESTROY_ASYNC_EVENT_QUEUE__ID = "id";
    public static final String DESTROY_ASYNC_EVENT_QUEUE__ID__HELP = "ID of the queue to be destroyed.";
    public static final String DESTROY_ASYNC_EVENT_QUEUE__GROUP__HELP = "Group(s) of members on which to destroy the async event queue.";
    public static final String DESTROY_ASYNC_EVENT_QUEUE__AEQ_0_NOT_FOUND = "Async event queue \"%s\" not found";
    public static final String DESTROY_ASYNC_EVENT_QUEUE__AEQ_0_DESTROYED = "Async event queue \"%s\" destroyed";

    @CliCommand(value={"destroy async-event-queue"}, help="destroy an Async Event Queue")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel destroyAsyncEventQueue(@CliOption(key={"id"}, mandatory=true, help="ID of the queue to be destroyed.") String aeqId, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members on which to destroy the async event queue.") String[] onGroups, @CliOption(key={"if-exists"}, help="If true, the command will be a no-op if the entity does not exist.", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean ifExists) {
        DestroyAsyncEventQueueFunctionArgs asyncEventQueueDestoryFunctionArgs = new DestroyAsyncEventQueueFunctionArgs(aeqId, ifExists);
        Set<DistributedMember> members = this.getMembers(onGroups, null);
        List<CliFunctionResult> functionResults = this.executeAndGetFunctionResult((Function<?>)new DestroyAsyncEventQueueFunction(), asyncEventQueueDestoryFunctionArgs, members);
        ResultModel result = ResultModel.createMemberStatusResult(functionResults);
        XmlEntity xmlEntity = this.getXmlEntity(functionResults);
        InternalConfigurationPersistenceService cps = (InternalConfigurationPersistenceService)this.getConfigurationPersistenceService();
        if (xmlEntity != null) {
            if (cps == null) {
                result.addInfo().addLine("Cluster configuration service is not running. Configuration change is not persisted.");
            } else {
                cps.deleteXmlEntity(xmlEntity, onGroups);
            }
        }
        return result;
    }

    private XmlEntity getXmlEntity(List<CliFunctionResult> functionResults) {
        return functionResults.stream().filter(CliFunctionResult::isSuccessful).map(CliFunctionResult::getXmlEntity).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

