/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CloseDurableClientFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CloseDurableClientCommand
extends GfshCommand {
    @CliCommand(value={"close durable-client"}, help="Attempts to close the durable client, the client must be disconnected.")
    @CliMetaData
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public ResultModel closeDurableClient(@CliOption(key={"durable-client-id"}, mandatory=true, help="The id used to identify the durable client.") String durableClientId, @CliOption(key={"member", "members"}, help="Name/Id of the member for which the durable client is to be closed.", optionContext="geode.converter.member.idOrName:disable-string-converter") String[] memberNameOrId, @CliOption(key={"group", "groups"}, help="Group of members for which the subscription queue events are to be counted.", optionContext="geode.converter.member.groups:disable-string-converter") String[] group) {
        Set<DistributedMember> targetMembers = this.findMembers(group, memberNameOrId);
        if (targetMembers.isEmpty()) {
            return ResultModel.createError("No Members Found");
        }
        ResultCollector<?, ?> rc = this.executeFunction((Function<?>)new CloseDurableClientFunction(), (Object)durableClientId, targetMembers);
        List results = (List)rc.getResult();
        return ResultModel.createMemberStatusResult(results);
    }
}

