/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.BaseCQCommand;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class MonitorCQ
extends BaseCQCommand {
    private static final MonitorCQ singleton = new MonitorCQ();

    public static Command getCommand() {
        return singleton;
    }

    private MonitorCQ() {
    }

    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, long start) throws IOException {
        int op;
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        if (!ServerConnection.allowInternalMessagesWithoutCredentials) {
            serverConnection.getAuthzRequest();
        }
        if ((op = clientMessage.getPart(0).getInt()) < 1) {
            String err = LocalizedStrings.MonitorCQ__0_THE_MONITORCQ_OPERATION_IS_INVALID.toLocalizedString(new Object[]{serverConnection.getName()});
            this.sendCqResponse(47, err, clientMessage.getTransactionId(), null, serverConnection);
            return;
        }
        String regionName = null;
        if (clientMessage.getNumberOfParts() == 2 && (regionName = clientMessage.getPart(1).getString()) == null) {
            String err = LocalizedStrings.MonitorCQ__0_A_NULL_REGION_NAME_WAS_PASSED_FOR_MONITORCQ_OPERATION.toLocalizedString(new Object[]{serverConnection.getName()});
            this.sendCqResponse(47, err, clientMessage.getTransactionId(), null, serverConnection);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received MonitorCq request from {} op: {}{}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString(), (Object)op, (Object)(regionName != null ? " RegionName: " + regionName : ""));
        }
        this.securityService.authorizeClusterRead();
        try {
            CqService cqService = crHelper.getCache().getCqService();
            cqService.start();
            throw new CqException(LocalizedStrings.CqService_INVALID_CQ_MONITOR_REQUEST_RECEIVED.toLocalizedString());
        }
        catch (CqException cqe) {
            this.sendCqResponse(50, "", clientMessage.getTransactionId(), cqe, serverConnection);
            return;
        }
        catch (Exception e) {
            String err = LocalizedStrings.MonitorCQ_EXCEPTION_WHILE_HANDLING_THE_MONITOR_REQUEST_OP_IS_0.toLocalizedString(new Object[]{op});
            this.sendCqResponse(50, err, clientMessage.getTransactionId(), e, serverConnection);
            return;
        }
    }
}

