/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;

public class OuterJoinPaddingUtil
implements Serializable {
    private static final long serialVersionUID = -2295909099427806938L;
    private final int leftArity;
    private final int rightArity;
    private transient JoinedRowData joinedRow = new JoinedRowData();
    private transient GenericRowData leftNullPaddingRow;
    private transient GenericRowData rightNullPaddingRow;

    public OuterJoinPaddingUtil(int leftArity, int rightArity) {
        this.leftArity = leftArity;
        this.rightArity = rightArity;
        this.initLeftNullPaddingRow();
        this.initRightNullPaddingRow();
    }

    private void initLeftNullPaddingRow() {
        this.leftNullPaddingRow = new GenericRowData(this.leftArity);
        for (int idx = 0; idx < this.leftArity; ++idx) {
            this.leftNullPaddingRow.setField(idx, null);
        }
    }

    private void initRightNullPaddingRow() {
        this.rightNullPaddingRow = new GenericRowData(this.rightArity);
        for (int idx = 0; idx < this.rightArity; ++idx) {
            this.rightNullPaddingRow.setField(idx, null);
        }
    }

    public final RowData padRight(RowData rightRow) {
        return this.joinedRow.replace((RowData)this.leftNullPaddingRow, rightRow);
    }

    public final RowData padLeft(RowData leftRow) {
        return this.joinedRow.replace(leftRow, (RowData)this.rightNullPaddingRow);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.joinedRow = new JoinedRowData();
        this.initLeftNullPaddingRow();
        this.initRightNullPaddingRow();
    }
}

