/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.runtimefilter;

import org.apache.flink.runtime.operators.util.BloomFilter;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.operators.runtimefilter.util.RuntimeFilterUtils;
import org.apache.flink.table.runtime.util.StreamRecordCollector;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class GlobalRuntimeFilterBuilderOperator
extends TableStreamOperator<RowData>
implements OneInputStreamOperator<RowData, RowData>,
BoundedOneInput {
    private final int maxRowCount;
    private transient byte[] serializedGlobalFilter;
    private transient Collector<RowData> collector;
    private transient int globalRowCount;

    public GlobalRuntimeFilterBuilderOperator(int maxRowCount) {
        Preconditions.checkArgument((maxRowCount > 0 ? 1 : 0) != 0);
        this.maxRowCount = maxRowCount;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.serializedGlobalFilter = null;
        this.collector = new StreamRecordCollector<RowData>(this.output);
        this.globalRowCount = 0;
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
        RowData rowData = (RowData)element.getValue();
        int localRowCount = rowData.getInt(0);
        if (this.globalRowCount != -1) {
            if (localRowCount == -1 || this.globalRowCount + localRowCount > this.maxRowCount) {
                this.globalRowCount = -1;
                this.serializedGlobalFilter = null;
            } else {
                byte[] serializedLocalFilter = rowData.getBinary(1);
                if (this.serializedGlobalFilter == null) {
                    this.serializedGlobalFilter = (byte[])serializedLocalFilter.clone();
                } else {
                    BloomFilter.mergeSerializedBloomFilters((byte[])this.serializedGlobalFilter, (byte[])serializedLocalFilter);
                }
                this.globalRowCount += localRowCount;
            }
        }
    }

    public void endInput() throws Exception {
        this.collector.collect((Object)RuntimeFilterUtils.convertBloomFilterToRowData(this.globalRowCount, this.serializedGlobalFilter));
    }
}

