/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;

@Internal
public class HiveAggDecimalPlusTypeStrategy
implements TypeStrategy {
    private static final String ERROR_MSG = "Both args of " + HiveAggDecimalPlusTypeStrategy.class.getSimpleName() + " should be of type[" + DecimalType.class.getSimpleName() + "]";

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        LogicalType addend1 = argumentDataTypes.get(0).getLogicalType();
        LogicalType addend2 = argumentDataTypes.get(1).getLogicalType();
        Preconditions.checkArgument((boolean)addend1.is(LogicalTypeRoot.DECIMAL), (Object)ERROR_MSG);
        Preconditions.checkArgument((boolean)addend2.is(LogicalTypeRoot.DECIMAL), (Object)ERROR_MSG);
        return Optional.of(TypeConversions.fromLogicalToDataType(addend2));
    }
}

