/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.columnar;

import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.TypedSetters;
import org.apache.flink.table.data.columnar.vector.ArrayColumnVector;
import org.apache.flink.table.data.columnar.vector.BooleanColumnVector;
import org.apache.flink.table.data.columnar.vector.ByteColumnVector;
import org.apache.flink.table.data.columnar.vector.BytesColumnVector;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.data.columnar.vector.DecimalColumnVector;
import org.apache.flink.table.data.columnar.vector.DoubleColumnVector;
import org.apache.flink.table.data.columnar.vector.FloatColumnVector;
import org.apache.flink.table.data.columnar.vector.IntColumnVector;
import org.apache.flink.table.data.columnar.vector.LongColumnVector;
import org.apache.flink.table.data.columnar.vector.MapColumnVector;
import org.apache.flink.table.data.columnar.vector.RowColumnVector;
import org.apache.flink.table.data.columnar.vector.ShortColumnVector;
import org.apache.flink.table.data.columnar.vector.TimestampColumnVector;

@Internal
public final class ColumnarArrayData
implements ArrayData,
TypedSetters {
    private final ColumnVector data;
    private final int offset;
    private final int numElements;

    public ColumnarArrayData(ColumnVector data, int offset, int numElements) {
        this.data = data;
        this.offset = offset;
        this.numElements = numElements;
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.data.isNullAt(this.offset + pos);
    }

    @Override
    public void setNullAt(int pos) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public boolean getBoolean(int pos) {
        return ((BooleanColumnVector)this.data).getBoolean(this.offset + pos);
    }

    @Override
    public byte getByte(int pos) {
        return ((ByteColumnVector)this.data).getByte(this.offset + pos);
    }

    @Override
    public short getShort(int pos) {
        return ((ShortColumnVector)this.data).getShort(this.offset + pos);
    }

    @Override
    public int getInt(int pos) {
        return ((IntColumnVector)this.data).getInt(this.offset + pos);
    }

    @Override
    public long getLong(int pos) {
        return ((LongColumnVector)this.data).getLong(this.offset + pos);
    }

    @Override
    public float getFloat(int pos) {
        return ((FloatColumnVector)this.data).getFloat(this.offset + pos);
    }

    @Override
    public double getDouble(int pos) {
        return ((DoubleColumnVector)this.data).getDouble(this.offset + pos);
    }

    @Override
    public StringData getString(int pos) {
        BytesColumnVector.Bytes byteArray = this.getByteArray(pos);
        return StringData.fromBytes(byteArray.data, byteArray.offset, byteArray.len);
    }

    @Override
    public DecimalData getDecimal(int pos, int precision, int scale) {
        return ((DecimalColumnVector)this.data).getDecimal(this.offset + pos, precision, scale);
    }

    @Override
    public TimestampData getTimestamp(int pos, int precision) {
        return ((TimestampColumnVector)this.data).getTimestamp(this.offset + pos, precision);
    }

    @Override
    public <T> RawValueData<T> getRawValue(int pos) {
        throw new UnsupportedOperationException("RawValueData is not supported.");
    }

    @Override
    public byte[] getBinary(int pos) {
        BytesColumnVector.Bytes byteArray = this.getByteArray(pos);
        if (byteArray.len == byteArray.data.length) {
            return byteArray.data;
        }
        return Arrays.copyOfRange(byteArray.data, byteArray.offset, byteArray.len);
    }

    @Override
    public ArrayData getArray(int pos) {
        return ((ArrayColumnVector)this.data).getArray(this.offset + pos);
    }

    @Override
    public MapData getMap(int pos) {
        return ((MapColumnVector)this.data).getMap(this.offset + pos);
    }

    @Override
    public RowData getRow(int pos, int numFields) {
        return ((RowColumnVector)this.data).getRow(this.offset + pos);
    }

    @Override
    public void setBoolean(int pos, boolean value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setByte(int pos, byte value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setShort(int pos, short value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setInt(int pos, int value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setLong(int pos, long value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setFloat(int pos, float value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setDouble(int pos, double value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setDecimal(int pos, DecimalData value, int precision) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setTimestamp(int pos, TimestampData value, int precision) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public boolean[] toBooleanArray() {
        boolean[] res = new boolean[this.numElements];
        for (int i = 0; i < this.numElements; ++i) {
            res[i] = this.getBoolean(i);
        }
        return res;
    }

    @Override
    public byte[] toByteArray() {
        byte[] res = new byte[this.numElements];
        for (int i = 0; i < this.numElements; ++i) {
            res[i] = this.getByte(i);
        }
        return res;
    }

    @Override
    public short[] toShortArray() {
        short[] res = new short[this.numElements];
        for (int i = 0; i < this.numElements; ++i) {
            res[i] = this.getShort(i);
        }
        return res;
    }

    @Override
    public int[] toIntArray() {
        int[] res = new int[this.numElements];
        for (int i = 0; i < this.numElements; ++i) {
            res[i] = this.getInt(i);
        }
        return res;
    }

    @Override
    public long[] toLongArray() {
        long[] res = new long[this.numElements];
        for (int i = 0; i < this.numElements; ++i) {
            res[i] = this.getLong(i);
        }
        return res;
    }

    @Override
    public float[] toFloatArray() {
        float[] res = new float[this.numElements];
        for (int i = 0; i < this.numElements; ++i) {
            res[i] = this.getFloat(i);
        }
        return res;
    }

    @Override
    public double[] toDoubleArray() {
        double[] res = new double[this.numElements];
        for (int i = 0; i < this.numElements; ++i) {
            res[i] = this.getDouble(i);
        }
        return res;
    }

    private BytesColumnVector.Bytes getByteArray(int pos) {
        return ((BytesColumnVector)this.data).getBytes(this.offset + pos);
    }
}

