/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.command;

import java.io.IOException;
import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.resource.ResourceType;
import org.apache.flink.table.resource.ResourceUri;

@Internal
public class AddJarOperation
implements Operation,
ExecutableOperation {
    private final String path;

    public AddJarOperation(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public String asSummaryString() {
        return String.format("ADD JAR '%s'", this.path);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        ResourceUri resourceUri = new ResourceUri(ResourceType.JAR, this.getPath());
        try {
            ctx.getResourceManager().registerJarResources(Collections.singletonList(resourceUri));
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (IOException e) {
            throw new TableException(String.format("Could not register the specified resource [%s].", resourceUri), (Throwable)e);
        }
    }
}

