/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.factories.TableFactoryService;
import org.apache.flink.table.factories.TableSinkFactory;
import org.apache.flink.table.factories.TableSourceFactory;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;

public class TableFactoryUtil {
    public static <T> TableSource<T> findAndCreateTableSource(Descriptor descriptor) {
        Map properties = descriptor.toProperties();
        return TableFactoryUtil.findAndCreateTableSource(properties);
    }

    private static <T> TableSource<T> findAndCreateTableSource(Map<String, String> properties) {
        try {
            return ((TableSourceFactory)TableFactoryService.find(TableSourceFactory.class, properties)).createTableSource(properties);
        }
        catch (Throwable t) {
            throw new TableException("findAndCreateTableSource failed.", t);
        }
    }

    public static <T> TableSink<T> findAndCreateTableSink(Descriptor descriptor) {
        Map properties = descriptor.toProperties();
        return TableFactoryUtil.findAndCreateTableSink(properties);
    }

    private static <T> TableSink<T> findAndCreateTableSink(Map<String, String> properties) {
        TableSink tableSink;
        try {
            tableSink = ((TableSinkFactory)TableFactoryService.find(TableSinkFactory.class, properties)).createTableSink(properties);
        }
        catch (Throwable t) {
            throw new TableException("findAndCreateTableSink failed.", t);
        }
        return tableSink;
    }

    public static <T> TableSink<T> findAndCreateTableSink(CatalogTable table) {
        return TableFactoryUtil.findAndCreateTableSink(table.toProperties());
    }

    public static <T> TableSource<T> findAndCreateTableSource(CatalogTable table) {
        return TableFactoryUtil.findAndCreateTableSource(table.toProperties());
    }

    public static Optional<TableSink> createTableSinkForCatalogTable(Catalog catalog, CatalogTable catalogTable, ObjectPath tablePath) {
        TableFactory tableFactory = catalog.getTableFactory().orElse(null);
        if (tableFactory instanceof TableSinkFactory) {
            return Optional.ofNullable(((TableSinkFactory)tableFactory).createTableSink(tablePath, catalogTable));
        }
        return Optional.empty();
    }
}

