/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver.lookups;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.types.DataType;

@Internal
public class FieldReferenceLookup {
    private final List<Map<String, FieldReferenceExpression>> fieldReferences;

    public FieldReferenceLookup(List<QueryOperation> queryOperations) {
        this.fieldReferences = FieldReferenceLookup.prepareFieldReferences(queryOperations);
    }

    public Optional<FieldReferenceExpression> lookupField(String name) {
        List matchingFields = this.fieldReferences.stream().map(input -> (FieldReferenceExpression)input.get(name)).filter(Objects::nonNull).collect(Collectors.toList());
        if (matchingFields.size() == 1) {
            return Optional.of(matchingFields.get(0));
        }
        if (matchingFields.size() == 0) {
            return Optional.empty();
        }
        throw FieldReferenceLookup.failAmbiuguousColumn(name);
    }

    public List<FieldReferenceExpression> getAllInputFields() {
        return this.fieldReferences.stream().flatMap(input -> input.values().stream()).collect(Collectors.toList());
    }

    private static List<Map<String, FieldReferenceExpression>> prepareFieldReferences(List<QueryOperation> queryOperations) {
        return IntStream.range(0, queryOperations.size()).mapToObj(idx -> FieldReferenceLookup.prepareFieldsInInput((QueryOperation)queryOperations.get(idx), idx)).collect(Collectors.toList());
    }

    private static Map<String, FieldReferenceExpression> prepareFieldsInInput(QueryOperation input, int inputIdx) {
        TableSchema tableSchema = input.getTableSchema();
        return IntStream.range(0, tableSchema.getFieldCount()).mapToObj(i -> new FieldReferenceExpression((String)tableSchema.getFieldName(i).get(), (DataType)tableSchema.getFieldDataType(i).get(), inputIdx, i)).collect(Collectors.toMap(FieldReferenceExpression::getName, Function.identity(), (fieldRef1, fieldRef2) -> {
            throw FieldReferenceLookup.failAmbiuguousColumn(fieldRef1.getName());
        }, LinkedHashMap::new));
    }

    private static ValidationException failAmbiuguousColumn(String name) {
        return new ValidationException("Ambiguous column name: " + name);
    }
}

