/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.internal.Registration;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.Schema;
import org.apache.flink.table.descriptors.TableDescriptor;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class ConnectTableDescriptor
extends TableDescriptor<ConnectTableDescriptor> {
    private final Registration registration;
    @Nullable
    private Schema schemaDescriptor;

    public ConnectTableDescriptor(Registration registration, ConnectorDescriptor connectorDescriptor) {
        super(connectorDescriptor);
        this.registration = registration;
    }

    public ConnectTableDescriptor withSchema(Schema schema) {
        this.schemaDescriptor = (Schema)Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        return this;
    }

    @Deprecated
    public void registerTableSource(String name) {
        Preconditions.checkNotNull((Object)name);
        TableSource tableSource = TableFactoryUtil.findAndCreateTableSource((Descriptor)this);
        this.registration.createTableSource(name, tableSource);
    }

    @Deprecated
    public void registerTableSink(String name) {
        Preconditions.checkNotNull((Object)name);
        TableSink tableSink = TableFactoryUtil.findAndCreateTableSink((Descriptor)this);
        this.registration.createTableSink(name, tableSink);
    }

    @Deprecated
    public void registerTableSourceAndSink(String name) {
        this.registerTableSource(name);
        this.registerTableSink(name);
    }

    public void createTemporaryTable(String path) {
        if (this.schemaDescriptor == null) {
            throw new TableException("Table schema must be explicitly defined. To derive schema from the underlying connector use registerTableSource/registerTableSink/registerTableSourceAndSink.");
        }
        Map schemaProperties = this.schemaDescriptor.toProperties();
        TableSchema tableSchema = this.getTableSchema(schemaProperties);
        HashMap<String, String> properties = new HashMap<String, String>(this.toProperties());
        schemaProperties.keySet().forEach(properties::remove);
        CatalogTableImpl catalogTable = new CatalogTableImpl(tableSchema, properties, "");
        this.registration.createTemporaryTable(path, (CatalogBaseTable)catalogTable);
    }

    private TableSchema getTableSchema(Map<String, String> schemaProperties) {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putProperties(schemaProperties);
        return properties.getTableSchema("schema");
    }

    protected Map<String, String> additionalProperties() {
        if (this.schemaDescriptor != null) {
            return this.schemaDescriptor.toProperties();
        }
        return Collections.emptyMap();
    }
}

