/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.runtime.io.BarrierBuffer;
import org.apache.flink.streaming.runtime.io.BarrierTracker;
import org.apache.flink.streaming.runtime.io.BufferSpiller;
import org.apache.flink.streaming.runtime.io.CachedBufferBlocker;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.tasks.StreamTask;

@Internal
public class InputProcessorUtil {
    public static CheckpointBarrierHandler createCheckpointBarrierHandler(StreamTask<?, ?> checkpointedTask, CheckpointingMode checkpointMode, IOManager ioManager, InputGate inputGate, Configuration taskManagerConfig) throws IOException {
        CheckpointBarrierHandler barrierHandler;
        if (checkpointMode == CheckpointingMode.EXACTLY_ONCE) {
            long maxAlign = taskManagerConfig.getLong(TaskManagerOptions.TASK_CHECKPOINT_ALIGNMENT_BYTES_LIMIT);
            if (maxAlign != -1L && maxAlign <= 0L) {
                throw new IllegalConfigurationException(TaskManagerOptions.TASK_CHECKPOINT_ALIGNMENT_BYTES_LIMIT.key() + " must be positive or -1 (infinite)");
            }
            barrierHandler = taskManagerConfig.getBoolean(TaskManagerOptions.NETWORK_CREDIT_MODEL) ? new BarrierBuffer(inputGate, new CachedBufferBlocker(inputGate.getPageSize()), maxAlign) : new BarrierBuffer(inputGate, new BufferSpiller(ioManager, inputGate.getPageSize()), maxAlign);
        } else if (checkpointMode == CheckpointingMode.AT_LEAST_ONCE) {
            barrierHandler = new BarrierTracker(inputGate);
        } else {
            throw new IllegalArgumentException("Unrecognized Checkpointing Mode: " + (Object)((Object)checkpointMode));
        }
        if (checkpointedTask != null) {
            barrierHandler.registerCheckpointEventHandler(checkpointedTask);
        }
        return barrierHandler;
    }
}

