/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.serialization;

import java.io.IOException;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.util.DataInputDeserializer;
import org.apache.flink.runtime.util.DataOutputSerializer;
import org.apache.flink.streaming.util.serialization.DeserializationSchema;
import org.apache.flink.streaming.util.serialization.SerializationSchema;

@Public
public class TypeInformationSerializationSchema<T>
implements DeserializationSchema<T>,
SerializationSchema<T> {
    private static final long serialVersionUID = -5359448468131559102L;
    private final TypeSerializer<T> serializer;
    private transient DataOutputSerializer dos;
    private transient DataInputDeserializer dis;
    private transient TypeInformation<T> typeInfo;

    public TypeInformationSerializationSchema(TypeInformation<T> typeInfo, ExecutionConfig ec) {
        this.typeInfo = typeInfo;
        this.serializer = typeInfo.createSerializer(ec);
    }

    @Override
    public T deserialize(byte[] message) {
        if (this.dis != null) {
            this.dis.setBuffer(message, 0, message.length);
        } else {
            this.dis = new DataInputDeserializer(message, 0, message.length);
        }
        try {
            return (T)this.serializer.deserialize((DataInputView)this.dis);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to deserialize message", e);
        }
    }

    @Override
    public boolean isEndOfStream(T nextElement) {
        return false;
    }

    @Override
    public byte[] serialize(T element) {
        if (this.dos == null) {
            this.dos = new DataOutputSerializer(16);
        }
        try {
            this.serializer.serialize(element, (DataOutputView)this.dos);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize record", e);
        }
        byte[] ret = this.dos.getByteArray();
        if (ret.length != this.dos.length()) {
            byte[] n = new byte[this.dos.length()];
            System.arraycopy(ret, 0, n, 0, this.dos.length());
            ret = n;
        }
        this.dos.clear();
        return ret;
    }

    public TypeInformation<T> getProducedType() {
        if (this.typeInfo != null) {
            return this.typeInfo;
        }
        throw new IllegalStateException("The type information is not available after this class has been serialized and distributed.");
    }
}

