/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.util.Objects;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.co.CoFlatMapFunction;
import org.apache.flink.streaming.api.functions.co.CoMapFunction;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.operators.co.CoStreamFlatMap;
import org.apache.flink.streaming.api.operators.co.CoStreamMap;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;

@Public
public class ConnectedStreams<IN1, IN2> {
    protected final StreamExecutionEnvironment environment;
    protected final DataStream<IN1> inputStream1;
    protected final DataStream<IN2> inputStream2;

    protected ConnectedStreams(StreamExecutionEnvironment env, DataStream<IN1> input1, DataStream<IN2> input2) {
        this.environment = Objects.requireNonNull(env);
        this.inputStream1 = Objects.requireNonNull(input1);
        this.inputStream2 = Objects.requireNonNull(input2);
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.environment;
    }

    public DataStream<IN1> getFirstInput() {
        return this.inputStream1;
    }

    public DataStream<IN2> getSecondInput() {
        return this.inputStream2;
    }

    public TypeInformation<IN1> getType1() {
        return this.inputStream1.getType();
    }

    public TypeInformation<IN2> getType2() {
        return this.inputStream2.getType();
    }

    public ConnectedStreams<IN1, IN2> keyBy(int keyPosition1, int keyPosition2) {
        return new ConnectedStreams<IN1, IN2>(this.environment, this.inputStream1.keyBy(keyPosition1), this.inputStream2.keyBy(keyPosition2));
    }

    public ConnectedStreams<IN1, IN2> keyBy(int[] keyPositions1, int[] keyPositions2) {
        return new ConnectedStreams<IN1, IN2>(this.environment, this.inputStream1.keyBy(keyPositions1), this.inputStream2.keyBy(keyPositions2));
    }

    public ConnectedStreams<IN1, IN2> keyBy(String field1, String field2) {
        return new ConnectedStreams<IN1, IN2>(this.environment, this.inputStream1.keyBy(field1), this.inputStream2.keyBy(field2));
    }

    public ConnectedStreams<IN1, IN2> keyBy(String[] fields1, String[] fields2) {
        return new ConnectedStreams<IN1, IN2>(this.environment, this.inputStream1.keyBy(fields1), this.inputStream2.keyBy(fields2));
    }

    public ConnectedStreams<IN1, IN2> keyBy(KeySelector<IN1, ?> keySelector1, KeySelector<IN2, ?> keySelector2) {
        return new ConnectedStreams<IN1, IN2>(this.environment, this.inputStream1.keyBy(keySelector1), this.inputStream2.keyBy(keySelector2));
    }

    public <R> SingleOutputStreamOperator<R> map(CoMapFunction<IN1, IN2, R> coMapper) {
        TypeInformation outTypeInfo = TypeExtractor.getBinaryOperatorReturnType(coMapper, CoMapFunction.class, (boolean)false, (boolean)true, this.getType1(), this.getType2(), (String)Utils.getCallLocationName(), (boolean)true);
        return this.transform("Co-Map", outTypeInfo, new CoStreamMap<IN1, IN2, R>(this.inputStream1.clean(coMapper)));
    }

    public <R> SingleOutputStreamOperator<R> flatMap(CoFlatMapFunction<IN1, IN2, R> coFlatMapper) {
        TypeInformation outTypeInfo = TypeExtractor.getBinaryOperatorReturnType(coFlatMapper, CoFlatMapFunction.class, (boolean)false, (boolean)true, this.getType1(), this.getType2(), (String)Utils.getCallLocationName(), (boolean)true);
        return this.transform("Co-Flat Map", outTypeInfo, new CoStreamFlatMap<IN1, IN2, R>(this.inputStream1.clean(coFlatMapper)));
    }

    @PublicEvolving
    public <R> SingleOutputStreamOperator<R> transform(String functionName, TypeInformation<R> outTypeInfo, TwoInputStreamOperator<IN1, IN2, R> operator) {
        this.inputStream1.getType();
        this.inputStream2.getType();
        TwoInputTransformation transform = new TwoInputTransformation(this.inputStream1.getTransformation(), this.inputStream2.getTransformation(), functionName, operator, outTypeInfo, this.environment.getParallelism());
        if (this.inputStream1 instanceof KeyedStream && this.inputStream2 instanceof KeyedStream) {
            TypeInformation keyType2;
            KeyedStream keyedInput1 = (KeyedStream)this.inputStream1;
            KeyedStream keyedInput2 = (KeyedStream)this.inputStream2;
            TypeInformation keyType1 = keyedInput1.getKeyType();
            if (!keyType1.canEqual(keyType2 = keyedInput2.getKeyType()) || !keyType1.equals(keyType2)) {
                throw new UnsupportedOperationException("Key types if input KeyedStreams don't match: " + keyType1 + " and " + keyType2 + ".");
            }
            transform.setStateKeySelectors(keyedInput1.getKeySelector(), keyedInput2.getKeySelector());
            transform.setStateKeyType(keyType1);
        }
        SingleOutputStreamOperator returnStream = new SingleOutputStreamOperator(this.environment, transform);
        this.getExecutionEnvironment().addOperator(transform);
        return returnStream;
    }
}

