/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.assigners;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.GlobalWindow;

@PublicEvolving
public class GlobalWindows
extends WindowAssigner<Object, GlobalWindow> {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final Trigger<Object, GlobalWindow> defaultTrigger;

    private GlobalWindows(Trigger<Object, GlobalWindow> defaultTrigger) {
        this.defaultTrigger = defaultTrigger;
    }

    @Override
    public Collection<GlobalWindow> assignWindows(Object element, long timestamp, WindowAssigner.WindowAssignerContext context) {
        return Collections.singletonList(GlobalWindow.get());
    }

    @Override
    public Trigger<Object, GlobalWindow> getDefaultTrigger(StreamExecutionEnvironment env) {
        throw new UnsupportedOperationException("This method is deprecated and shouldn't be invoked. Please use getDefaultTrigger() instead.");
    }

    @Override
    public Trigger<Object, GlobalWindow> getDefaultTrigger() {
        return this.defaultTrigger == null ? new NeverTrigger() : this.defaultTrigger;
    }

    public String toString() {
        return "GlobalWindows(trigger=" + this.getDefaultTrigger().getClass().getSimpleName() + ")";
    }

    public static GlobalWindows create() {
        return new GlobalWindows(new NeverTrigger());
    }

    public static GlobalWindows createWithEndOfStreamTrigger() {
        return new GlobalWindows(new EndOfStreamTrigger());
    }

    @Override
    public TypeSerializer<GlobalWindow> getWindowSerializer(ExecutionConfig executionConfig) {
        return new GlobalWindow.Serializer();
    }

    @Override
    public boolean isEventTime() {
        return false;
    }

    @Internal
    public static class EndOfStreamTrigger
    extends Trigger<Object, GlobalWindow> {
        private static final long serialVersionUID = 1L;

        @Override
        public TriggerResult onElement(Object element, long timestamp, GlobalWindow window, Trigger.TriggerContext ctx) {
            ctx.registerEventTimeTimer(window.maxTimestamp());
            return TriggerResult.CONTINUE;
        }

        @Override
        public TriggerResult onEventTime(long time, GlobalWindow window, Trigger.TriggerContext ctx) {
            return time == window.maxTimestamp() ? TriggerResult.FIRE : TriggerResult.CONTINUE;
        }

        @Override
        public TriggerResult onProcessingTime(long time, GlobalWindow window, Trigger.TriggerContext ctx) {
            return TriggerResult.CONTINUE;
        }

        @Override
        public void clear(GlobalWindow window, Trigger.TriggerContext ctx) throws Exception {
        }

        @Override
        public void onMerge(GlobalWindow window, Trigger.OnMergeContext ctx) {
        }
    }

    @Internal
    public static class NeverTrigger
    extends Trigger<Object, GlobalWindow> {
        private static final long serialVersionUID = 1L;

        @Override
        public TriggerResult onElement(Object element, long timestamp, GlobalWindow window, Trigger.TriggerContext ctx) {
            return TriggerResult.CONTINUE;
        }

        @Override
        public TriggerResult onEventTime(long time, GlobalWindow window, Trigger.TriggerContext ctx) {
            return TriggerResult.CONTINUE;
        }

        @Override
        public TriggerResult onProcessingTime(long time, GlobalWindow window, Trigger.TriggerContext ctx) {
            return TriggerResult.CONTINUE;
        }

        @Override
        public void clear(GlobalWindow window, Trigger.TriggerContext ctx) throws Exception {
        }

        @Override
        public void onMerge(GlobalWindow window, Trigger.OnMergeContext ctx) {
        }
    }
}

