/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.v2.DiscardingSink;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class CheckpointExceptionHandlerConfigurationTest
extends TestLogger {
    @Test
    public void testCheckpointConfigDefault() {
        StreamExecutionEnvironment streamExecutionEnvironment = StreamExecutionEnvironment.getExecutionEnvironment();
        CheckpointConfig checkpointConfig = streamExecutionEnvironment.getCheckpointConfig();
        Assert.assertTrue((boolean)checkpointConfig.isFailOnCheckpointingErrors());
        Assert.assertEquals((long)0L, (long)checkpointConfig.getTolerableCheckpointFailureNumber());
    }

    @Test
    public void testSetCheckpointConfig() {
        StreamExecutionEnvironment streamExecutionEnvironment = StreamExecutionEnvironment.getExecutionEnvironment();
        CheckpointConfig checkpointConfig = streamExecutionEnvironment.getCheckpointConfig();
        checkpointConfig.setFailOnCheckpointingErrors(false);
        Assert.assertFalse((boolean)checkpointConfig.isFailOnCheckpointingErrors());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)checkpointConfig.getTolerableCheckpointFailureNumber());
        checkpointConfig.setTolerableCheckpointFailureNumber(5);
        Assert.assertEquals((long)5L, (long)checkpointConfig.getTolerableCheckpointFailureNumber());
        checkpointConfig.setFailOnCheckpointingErrors(true);
        Assert.assertEquals((long)5L, (long)checkpointConfig.getTolerableCheckpointFailureNumber());
    }

    @Test
    public void testPropagationFailFromCheckpointConfig() {
        try {
            this.doTestPropagationFromCheckpointConfig(true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPropagationDeclineFromCheckpointConfig() {
        this.doTestPropagationFromCheckpointConfig(false);
    }

    public void doTestPropagationFromCheckpointConfig(boolean failTaskOnCheckpointErrors) {
        StreamExecutionEnvironment streamExecutionEnvironment = StreamExecutionEnvironment.getExecutionEnvironment();
        streamExecutionEnvironment.setParallelism(1);
        streamExecutionEnvironment.getCheckpointConfig().setCheckpointInterval(1000L);
        streamExecutionEnvironment.getCheckpointConfig().setFailOnCheckpointingErrors(failTaskOnCheckpointErrors);
        streamExecutionEnvironment.addSource((SourceFunction)new SourceFunction<Integer>(){

            public void run(SourceFunction.SourceContext<Integer> ctx) {
            }

            public void cancel() {
            }
        }).sinkTo((Sink)new DiscardingSink());
    }
}

