/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import org.apache.flink.streaming.api.operators.InputSelection;
import org.apache.flink.streaming.runtime.io.MultipleInputSelectionHandler;
import org.junit.Assert;
import org.junit.Test;

public class MultipleInputSelectionHandlerTest {
    @Test
    public void testShouldSetAvailableForAnotherInput() {
        InputSelection secondAndThird = new InputSelection.Builder().select(2).select(3).build();
        MultipleInputSelectionHandler selectionHandler = new MultipleInputSelectionHandler(() -> secondAndThird, 3);
        selectionHandler.nextSelection();
        Assert.assertFalse((boolean)selectionHandler.shouldSetAvailableForAnotherInput());
        selectionHandler.setUnavailableInput(0);
        Assert.assertFalse((boolean)selectionHandler.shouldSetAvailableForAnotherInput());
        selectionHandler.setUnavailableInput(2);
        Assert.assertTrue((boolean)selectionHandler.shouldSetAvailableForAnotherInput());
        selectionHandler.setAvailableInput(0);
        Assert.assertTrue((boolean)selectionHandler.shouldSetAvailableForAnotherInput());
        selectionHandler.setAvailableInput(2);
        Assert.assertFalse((boolean)selectionHandler.shouldSetAvailableForAnotherInput());
    }

    @Test
    public void testLargeInputCount() {
        int inputCount = 63;
        InputSelection.Builder builder = new InputSelection.Builder();
        for (int i = 1; i <= inputCount; ++i) {
            builder.select(i);
        }
        InputSelection allSelected = builder.build();
        MultipleInputSelectionHandler selectionHandler = new MultipleInputSelectionHandler(() -> allSelected, inputCount);
        selectionHandler.nextSelection();
        for (int i = 0; i < inputCount - 1; ++i) {
            selectionHandler.setUnavailableInput(i);
        }
        Assert.assertTrue((boolean)selectionHandler.isAnyInputAvailable());
        selectionHandler.setUnavailableInput(inputCount - 1);
        Assert.assertFalse((boolean)selectionHandler.isAnyInputAvailable());
    }
}

