/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.SupportsConcurrentExecutionAttempts;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.functions.sink.OutputFormatSinkFunction;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OutputFormatOperatorFactory;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.api.operators.UserFunctionProvider;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;

@Internal
public class LegacySinkTransformation<T>
extends PhysicalTransformation<T> {
    private final Transformation<T> input;
    private final StreamOperatorFactory<Object> operatorFactory;
    private KeySelector<T, ?> stateKeySelector;
    private TypeInformation<?> stateKeyType;

    public LegacySinkTransformation(Transformation<T> input, String name, StreamSink<T> operator, int parallelism, boolean parallelismConfigured) {
        this(input, name, SimpleOperatorFactory.of(operator), parallelism, parallelismConfigured);
    }

    public LegacySinkTransformation(Transformation<T> input, String name, StreamOperatorFactory<Object> operatorFactory, int parallelism) {
        super(name, input.getOutputType(), parallelism);
        this.input = input;
        this.operatorFactory = operatorFactory;
    }

    public LegacySinkTransformation(Transformation<T> input, String name, StreamOperatorFactory<Object> operatorFactory, int parallelism, boolean parallelismConfigured) {
        super(name, input.getOutputType(), parallelism, parallelismConfigured);
        this.input = input;
        this.operatorFactory = operatorFactory;
    }

    @VisibleForTesting
    public StreamSink<T> getOperator() {
        return (StreamSink)((SimpleOperatorFactory)this.operatorFactory).getOperator();
    }

    public StreamOperatorFactory<Object> getOperatorFactory() {
        return this.operatorFactory;
    }

    public void setStateKeySelector(KeySelector<T, ?> stateKeySelector) {
        this.stateKeySelector = stateKeySelector;
        this.updateManagedMemoryStateBackendUseCase(stateKeySelector != null);
    }

    public KeySelector<T, ?> getStateKeySelector() {
        return this.stateKeySelector;
    }

    public void setStateKeyType(TypeInformation<?> stateKeyType) {
        this.stateKeyType = stateKeyType;
    }

    public TypeInformation<?> getStateKeyType() {
        return this.stateKeyType;
    }

    public List<Transformation<?>> getTransitivePredecessors() {
        ArrayList result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }

    public List<Transformation<?>> getInputs() {
        return Collections.singletonList(this.input);
    }

    @Override
    public final void setChainingStrategy(ChainingStrategy strategy) {
        this.operatorFactory.setChainingStrategy(strategy);
    }

    @Override
    public boolean isSupportsConcurrentExecutionAttempts() {
        if (!super.isSupportsConcurrentExecutionAttempts()) {
            return false;
        }
        if (this.operatorFactory instanceof SimpleOperatorFactory) {
            StreamOperator operator = ((SimpleOperatorFactory)this.operatorFactory).getOperator();
            if (operator instanceof UserFunctionProvider) {
                Object userFunction = ((UserFunctionProvider)((Object)operator)).getUserFunction();
                if (userFunction instanceof SupportsConcurrentExecutionAttempts) {
                    return true;
                }
                if (userFunction instanceof OutputFormatSinkFunction) {
                    return ((OutputFormatSinkFunction)userFunction).getFormat() instanceof SupportsConcurrentExecutionAttempts;
                }
            }
        } else if (this.operatorFactory instanceof OutputFormatOperatorFactory) {
            OutputFormat outputFormat = ((OutputFormatOperatorFactory)this.operatorFactory).getOutputFormat();
            return outputFormat instanceof SupportsConcurrentExecutionAttempts;
        }
        return false;
    }
}

