/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.DoubleCounter;
import org.apache.flink.api.common.accumulators.Histogram;
import org.apache.flink.api.common.accumulators.IntCounter;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.externalresource.ExternalResourceInfo;
import org.apache.flink.api.common.functions.BroadcastVariableInitializer;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.AggregatingState;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.KeyedStateStore;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.util.Preconditions;

@Internal
public final class SavepointRuntimeContext
implements RuntimeContext {
    private static final String REGISTRATION_EXCEPTION_MSG = "State Descriptors may only be registered inside of open";
    private final RuntimeContext ctx;
    private final KeyedStateStore keyedStateStore;
    private final List<StateDescriptor<?, ?>> registeredDescriptors;
    private boolean stateRegistrationAllowed;

    public SavepointRuntimeContext(RuntimeContext ctx, KeyedStateStore keyedStateStore) {
        this.ctx = (RuntimeContext)Preconditions.checkNotNull((Object)ctx);
        this.keyedStateStore = (KeyedStateStore)Preconditions.checkNotNull((Object)keyedStateStore);
        this.stateRegistrationAllowed = true;
        this.registeredDescriptors = new ArrayList();
    }

    public JobID getJobId() {
        return this.ctx.getJobId();
    }

    public String getTaskName() {
        return this.ctx.getTaskName();
    }

    public OperatorMetricGroup getMetricGroup() {
        return this.ctx.getMetricGroup();
    }

    public int getNumberOfParallelSubtasks() {
        return this.ctx.getNumberOfParallelSubtasks();
    }

    public int getMaxNumberOfParallelSubtasks() {
        return this.ctx.getMaxNumberOfParallelSubtasks();
    }

    public int getIndexOfThisSubtask() {
        return this.ctx.getIndexOfThisSubtask();
    }

    public int getAttemptNumber() {
        return this.ctx.getAttemptNumber();
    }

    public String getTaskNameWithSubtasks() {
        return this.ctx.getTaskNameWithSubtasks();
    }

    public ExecutionConfig getExecutionConfig() {
        return this.ctx.getExecutionConfig();
    }

    public ClassLoader getUserCodeClassLoader() {
        return this.ctx.getUserCodeClassLoader();
    }

    public void registerUserCodeClassLoaderReleaseHookIfAbsent(String releaseHookName, Runnable releaseHook) {
        this.ctx.registerUserCodeClassLoaderReleaseHookIfAbsent(releaseHookName, releaseHook);
    }

    public <V, A extends Serializable> void addAccumulator(String name, Accumulator<V, A> accumulator) {
        this.ctx.addAccumulator(name, accumulator);
    }

    public <V, A extends Serializable> Accumulator<V, A> getAccumulator(String name) {
        return this.ctx.getAccumulator(name);
    }

    public IntCounter getIntCounter(String name) {
        return this.ctx.getIntCounter(name);
    }

    public LongCounter getLongCounter(String name) {
        return this.ctx.getLongCounter(name);
    }

    public DoubleCounter getDoubleCounter(String name) {
        return this.ctx.getDoubleCounter(name);
    }

    public Histogram getHistogram(String name) {
        return this.ctx.getHistogram(name);
    }

    public Set<ExternalResourceInfo> getExternalResourceInfos(String resourceName) {
        throw new UnsupportedOperationException("Do not support external resource in current environment");
    }

    public boolean hasBroadcastVariable(String name) {
        return this.ctx.hasBroadcastVariable(name);
    }

    public <RT> List<RT> getBroadcastVariable(String name) {
        return this.ctx.getBroadcastVariable(name);
    }

    public <T, C> C getBroadcastVariableWithInitializer(String name, BroadcastVariableInitializer<T, C> initializer) {
        return (C)this.ctx.getBroadcastVariableWithInitializer(name, initializer);
    }

    public DistributedCache getDistributedCache() {
        return this.ctx.getDistributedCache();
    }

    public <T> ValueState<T> getState(ValueStateDescriptor<T> stateProperties) {
        if (!this.stateRegistrationAllowed) {
            throw new RuntimeException(REGISTRATION_EXCEPTION_MSG);
        }
        this.registeredDescriptors.add((StateDescriptor<?, ?>)stateProperties);
        return this.keyedStateStore.getState(stateProperties);
    }

    public <T> ListState<T> getListState(ListStateDescriptor<T> stateProperties) {
        if (!this.stateRegistrationAllowed) {
            throw new RuntimeException(REGISTRATION_EXCEPTION_MSG);
        }
        this.registeredDescriptors.add((StateDescriptor<?, ?>)stateProperties);
        return this.keyedStateStore.getListState(stateProperties);
    }

    public <T> ReducingState<T> getReducingState(ReducingStateDescriptor<T> stateProperties) {
        if (!this.stateRegistrationAllowed) {
            throw new RuntimeException(REGISTRATION_EXCEPTION_MSG);
        }
        this.registeredDescriptors.add((StateDescriptor<?, ?>)stateProperties);
        return this.keyedStateStore.getReducingState(stateProperties);
    }

    public <IN, ACC, OUT> AggregatingState<IN, OUT> getAggregatingState(AggregatingStateDescriptor<IN, ACC, OUT> stateProperties) {
        if (!this.stateRegistrationAllowed) {
            throw new RuntimeException(REGISTRATION_EXCEPTION_MSG);
        }
        this.registeredDescriptors.add((StateDescriptor<?, ?>)stateProperties);
        return this.keyedStateStore.getAggregatingState(stateProperties);
    }

    public <UK, UV> MapState<UK, UV> getMapState(MapStateDescriptor<UK, UV> stateProperties) {
        if (!this.stateRegistrationAllowed) {
            throw new RuntimeException(REGISTRATION_EXCEPTION_MSG);
        }
        this.registeredDescriptors.add((StateDescriptor<?, ?>)stateProperties);
        return this.keyedStateStore.getMapState(stateProperties);
    }

    public List<StateDescriptor<?, ?>> getStateDescriptors() {
        if (this.registeredDescriptors.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList(this.registeredDescriptors);
    }

    public void disableStateRegistration() throws Exception {
        this.stateRegistrationAllowed = false;
    }
}

