/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferPoolOwner;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.util.event.EventListener;
import org.apache.flink.util.Preconditions;

class LocalBufferPool
implements BufferPool {
    private final NetworkBufferPool networkBufferPool;
    private final int numberOfRequiredMemorySegments;
    private final Queue<MemorySegment> availableMemorySegments = new ArrayDeque<MemorySegment>();
    private final Queue<EventListener<Buffer>> registeredListeners = new ArrayDeque<EventListener<Buffer>>();
    private int currentPoolSize;
    private int numberOfRequestedMemorySegments;
    private boolean isDestroyed;
    private BufferPoolOwner owner;

    LocalBufferPool(NetworkBufferPool networkBufferPool, int numberOfRequiredMemorySegments) {
        this.networkBufferPool = networkBufferPool;
        this.numberOfRequiredMemorySegments = numberOfRequiredMemorySegments;
        this.currentPoolSize = numberOfRequiredMemorySegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Queue<MemorySegment> queue = this.availableMemorySegments;
        synchronized (queue) {
            return this.isDestroyed;
        }
    }

    @Override
    public int getMemorySegmentSize() {
        return this.networkBufferPool.getMemorySegmentSize();
    }

    @Override
    public int getNumberOfRequiredMemorySegments() {
        return this.numberOfRequiredMemorySegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfAvailableMemorySegments() {
        Queue<MemorySegment> queue = this.availableMemorySegments;
        synchronized (queue) {
            return this.availableMemorySegments.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumBuffers() {
        Queue<MemorySegment> queue = this.availableMemorySegments;
        synchronized (queue) {
            return this.currentPoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBufferPoolOwner(BufferPoolOwner owner) {
        Queue<MemorySegment> queue = this.availableMemorySegments;
        synchronized (queue) {
            Preconditions.checkState((this.owner == null ? 1 : 0) != 0, (Object)"Buffer pool owner has already been set.");
            this.owner = (BufferPoolOwner)Preconditions.checkNotNull((Object)owner);
        }
    }

    @Override
    public Buffer requestBuffer() throws IOException {
        try {
            return this.requestBuffer(false);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Buffer requestBufferBlocking() throws IOException, InterruptedException {
        return this.requestBuffer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Buffer requestBuffer(boolean isBlocking) throws InterruptedException, IOException {
        Queue<MemorySegment> queue = this.availableMemorySegments;
        synchronized (queue) {
            boolean askToRecycle;
            this.returnExcessMemorySegments();
            boolean bl = askToRecycle = this.owner != null;
            while (this.availableMemorySegments.isEmpty()) {
                MemorySegment segment;
                if (this.isDestroyed) {
                    throw new IllegalStateException("Buffer pool is destroyed.");
                }
                if (this.numberOfRequestedMemorySegments < this.currentPoolSize && (segment = this.networkBufferPool.requestMemorySegment()) != null) {
                    ++this.numberOfRequestedMemorySegments;
                    this.availableMemorySegments.add(segment);
                    continue;
                }
                if (askToRecycle) {
                    this.owner.releaseMemory(1);
                }
                if (isBlocking) {
                    this.availableMemorySegments.wait(2000L);
                    continue;
                }
                return null;
            }
            return new Buffer(this.availableMemorySegments.poll(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle(MemorySegment segment) {
        Queue<MemorySegment> queue = this.availableMemorySegments;
        synchronized (queue) {
            if (this.isDestroyed || this.numberOfRequestedMemorySegments > this.currentPoolSize) {
                this.returnMemorySegment(segment);
            } else {
                EventListener<Buffer> listener = this.registeredListeners.poll();
                if (listener == null) {
                    this.availableMemorySegments.add(segment);
                    this.availableMemorySegments.notify();
                } else {
                    try {
                        listener.onEvent(new Buffer(segment, this));
                    }
                    catch (Throwable ignored) {
                        this.availableMemorySegments.add(segment);
                        this.availableMemorySegments.notify();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lazyDestroy() {
        Queue<MemorySegment> queue = this.availableMemorySegments;
        synchronized (queue) {
            if (!this.isDestroyed) {
                EventListener<Buffer> listener;
                MemorySegment segment;
                while ((segment = this.availableMemorySegments.poll()) != null) {
                    this.returnMemorySegment(segment);
                }
                while ((listener = this.registeredListeners.poll()) != null) {
                    listener.onEvent(null);
                }
                this.isDestroyed = true;
            }
        }
        this.networkBufferPool.destroyBufferPool(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addListener(EventListener<Buffer> listener) {
        Queue<MemorySegment> queue = this.availableMemorySegments;
        synchronized (queue) {
            if (!this.availableMemorySegments.isEmpty() || this.isDestroyed) {
                return false;
            }
            this.registeredListeners.add(listener);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNumBuffers(int numBuffers) throws IOException {
        Queue<MemorySegment> queue = this.availableMemorySegments;
        synchronized (queue) {
            Preconditions.checkArgument((numBuffers >= this.numberOfRequiredMemorySegments ? 1 : 0) != 0, (Object)("Buffer pool needs at least " + this.numberOfRequiredMemorySegments + " buffers, but tried to set to " + numBuffers + "."));
            this.currentPoolSize = numBuffers;
            this.returnExcessMemorySegments();
            if (this.owner != null && this.numberOfRequestedMemorySegments > this.currentPoolSize) {
                this.owner.releaseMemory(this.numberOfRequestedMemorySegments - numBuffers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Queue<MemorySegment> queue = this.availableMemorySegments;
        synchronized (queue) {
            return String.format("[size: %d, required: %d, requested: %d, available: %d, listeners: %d, destroyed: %s]", this.currentPoolSize, this.numberOfRequiredMemorySegments, this.numberOfRequestedMemorySegments, this.availableMemorySegments.size(), this.registeredListeners.size(), this.isDestroyed);
        }
    }

    private void returnMemorySegment(MemorySegment segment) {
        --this.numberOfRequestedMemorySegments;
        this.networkBufferPool.recycle(segment);
    }

    private void returnExcessMemorySegments() {
        while (this.numberOfRequestedMemorySegments > this.currentPoolSize) {
            MemorySegment segment = this.availableMemorySegments.poll();
            if (segment == null) {
                return;
            }
            this.networkBufferPool.recycle(segment);
            --this.numberOfRequestedMemorySegments;
        }
    }
}

