/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import java.util.concurrent.Callable;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExecutionGraphRestarter {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionGraphRestarter.class);

    ExecutionGraphRestarter() {
    }

    public static Callable<Object> restartWithDelay(final ExecutionGraph executionGraph, final long delayBetweenRestartAttemptsInMillis) {
        return new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    LOG.info("Delaying retry of job execution for {} ms ...", (Object)delayBetweenRestartAttemptsInMillis);
                    Thread.sleep(delayBetweenRestartAttemptsInMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                executionGraph.restart();
                return null;
            }
        };
    }
}

