/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import com.typesafe.config.Config;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.Iterator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.ContaineredTaskManagerParameters;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.runtime.webmonitor.WebMonitor;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.apache.flink.util.NetUtils;
import org.jboss.netty.channel.ChannelException;
import org.slf4j.Logger;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration;

public class BootstrapTools {
    public static ActorSystem startActorSystem(Configuration configuration, String listeningAddress, String portRangeDefinition, Logger logger) throws Exception {
        Iterator portsIterator;
        try {
            portsIterator = NetUtils.getPortRangeFromString((String)portRangeDefinition);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid port range definition: " + portRangeDefinition);
        }
        while (portsIterator.hasNext()) {
            ServerSocket availableSocket = NetUtils.createSocketFromPorts((Iterator)portsIterator, (NetUtils.SocketFactory)new NetUtils.SocketFactory(){

                public ServerSocket createSocket(int port) throws IOException {
                    return new ServerSocket(port);
                }
            });
            if (availableSocket == null) {
                throw new BindException("Unable to allocate further port in port range: " + portRangeDefinition);
            }
            int port = availableSocket.getLocalPort();
            try {
                availableSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                return BootstrapTools.startActorSystem(configuration, listeningAddress, port, logger);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof ChannelException || cause instanceof BindException) continue;
                throw e;
            }
        }
        throw new BindException("Could not start actor system on any port in port range " + portRangeDefinition);
    }

    public static ActorSystem startActorSystem(Configuration configuration, String listeningAddress, int listeningPort, Logger logger) throws Exception {
        String hostPortUrl = NetUtils.hostAndPortToUrlString((String)listeningAddress, (int)listeningPort);
        logger.info("Trying to start actor system at {}", (Object)hostPortUrl);
        try {
            Config akkaConfig = AkkaUtils.getAkkaConfig(configuration, (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)listeningAddress, (Object)listeningPort)));
            logger.debug("Using akka configuration\n {}", (Object)akkaConfig);
            ActorSystem actorSystem = AkkaUtils.createActorSystem(akkaConfig);
            logger.info("Actor system started at {}", (Object)hostPortUrl);
            return actorSystem;
        }
        catch (Throwable t) {
            Throwable cause;
            if (t instanceof ChannelException && (cause = t.getCause()) != null && t.getCause() instanceof BindException) {
                throw new IOException("Unable to create ActorSystem at address " + hostPortUrl + " : " + cause.getMessage(), t);
            }
            throw new Exception("Could not create actor system", t);
        }
    }

    public static WebMonitor startWebMonitorIfConfigured(Configuration config, ActorSystem actorSystem, ActorRef jobManager, Logger logger) throws Exception {
        Address address = AkkaUtils.getAddress(actorSystem);
        config.setString("jobmanager.rpc.address", (String)address.host().get());
        config.setString("jobmanager.rpc.port", address.port().get().toString());
        if (config.getInteger("jobmanager.web.port", 0) >= 0) {
            logger.info("Starting JobManager Web Frontend");
            LeaderRetrievalService leaderRetrievalService = LeaderRetrievalUtils.createLeaderRetrievalService(config, jobManager);
            WebMonitor monitor = WebMonitorUtils.startWebRuntimeMonitor(config, leaderRetrievalService, actorSystem);
            if (monitor != null) {
                String jobManagerAkkaURL = AkkaUtils.getAkkaURL(actorSystem, jobManager);
                monitor.start(jobManagerAkkaURL);
            }
            return monitor;
        }
        return null;
    }

    public static Configuration generateTaskManagerConfiguration(Configuration baseConfig, String jobManagerHostname, int jobManagerPort, int numSlots, FiniteDuration registrationTimeout) {
        Configuration cfg = baseConfig.clone();
        cfg.setString("jobmanager.rpc.address", jobManagerHostname);
        cfg.setInteger("jobmanager.rpc.port", jobManagerPort);
        cfg.setString("taskmanager.maxRegistrationDuration", registrationTimeout.toString());
        if (numSlots != -1) {
            cfg.setInteger("taskmanager.numberOfTaskSlots", numSlots);
        }
        return cfg;
    }

    public static void writeConfiguration(Configuration cfg, File file) throws IOException {
        try (FileWriter fwrt = new FileWriter(file);
             PrintWriter out = new PrintWriter(fwrt);){
            for (String key : cfg.keySet()) {
                String value = cfg.getString(key, null);
                out.print(key);
                out.print(": ");
                out.println(value);
            }
        }
    }

    public static void substituteDeprecatedConfigKey(Configuration config, String deprecated, String designated) {
        String valueForDeprecated;
        if (!config.containsKey(designated) && (valueForDeprecated = config.getString(deprecated, null)) != null) {
            config.setString(designated, valueForDeprecated);
        }
    }

    public static void substituteDeprecatedConfigPrefix(Configuration config, String deprecatedPrefix, String designatedPrefix) {
        int prefixLen = deprecatedPrefix.length();
        Configuration replacement = new Configuration();
        for (String key : config.keySet()) {
            String newKey;
            if (!key.startsWith(deprecatedPrefix) || config.containsKey(newKey = designatedPrefix + key.substring(prefixLen))) continue;
            replacement.setString(newKey, config.getString(key, null));
        }
        config.addAll(replacement);
    }

    public static String getTaskManagerShellCommand(Configuration flinkConfig, ContaineredTaskManagerParameters tmParams, String configDirectory, String logDirectory, boolean hasLogback, boolean hasLog4j, Class<?> mainClass) {
        StringBuilder tmCommand = new StringBuilder("$JAVA_HOME/bin/java");
        tmCommand.append(" -Xms").append(tmParams.taskManagerHeapSizeMB()).append("m");
        tmCommand.append(" -Xmx").append(tmParams.taskManagerHeapSizeMB()).append("m");
        tmCommand.append(" -XX:MaxDirectMemorySize=").append(tmParams.taskManagerDirectMemoryLimitMB()).append("m");
        String javaOpts = flinkConfig.getString("env.java.opts", "");
        tmCommand.append(' ').append(javaOpts);
        if (hasLogback || hasLog4j) {
            tmCommand.append(" -Dlog.file=").append(logDirectory).append("/taskmanager.log");
            if (hasLogback) {
                tmCommand.append(" -Dlogback.configurationFile=file:").append(configDirectory).append("/logback.xml");
            }
            if (hasLog4j) {
                tmCommand.append(" -Dlog4j.configuration=file:").append(configDirectory).append("/log4j.properties");
            }
        }
        tmCommand.append(' ').append(mainClass.getName());
        tmCommand.append(" --configDir ").append(configDirectory);
        tmCommand.append(" 1> ").append(logDirectory).append("/taskmanager.out");
        tmCommand.append(" 2> ").append(logDirectory).append("/taskmanager.err");
        return tmCommand.toString();
    }

    private BootstrapTools() {
    }
}

