/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.KeyGroupState;
import org.apache.flink.runtime.checkpoint.SubtaskState;
import org.apache.flink.runtime.checkpoint.TaskState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.util.SerializedValue;

public class PendingCheckpoint {
    private final Object lock = new Object();
    private final JobID jobId;
    private final long checkpointId;
    private final long checkpointTimestamp;
    private final Map<JobVertexID, TaskState> taskStates;
    private final Map<ExecutionAttemptID, ExecutionVertex> notYetAcknowledgedTasks;
    private int numAcknowledgedTasks;
    private boolean discarded;

    public PendingCheckpoint(JobID jobId, long checkpointId, long checkpointTimestamp, Map<ExecutionAttemptID, ExecutionVertex> verticesToConfirm) {
        if (jobId == null || verticesToConfirm == null) {
            throw new NullPointerException();
        }
        if (verticesToConfirm.size() == 0) {
            throw new IllegalArgumentException("Checkpoint needs at least one vertex that commits the checkpoint");
        }
        this.jobId = jobId;
        this.checkpointId = checkpointId;
        this.checkpointTimestamp = checkpointTimestamp;
        this.notYetAcknowledgedTasks = verticesToConfirm;
        this.taskStates = new HashMap<JobVertexID, TaskState>();
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public long getCheckpointTimestamp() {
        return this.checkpointTimestamp;
    }

    public int getNumberOfNonAcknowledgedTasks() {
        return this.notYetAcknowledgedTasks.size();
    }

    public int getNumberOfAcknowledgedTasks() {
        return this.numAcknowledgedTasks;
    }

    public Map<JobVertexID, TaskState> getTaskStates() {
        return this.taskStates;
    }

    public boolean isFullyAcknowledged() {
        return this.notYetAcknowledgedTasks.isEmpty() && !this.discarded;
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    public CompletedCheckpoint finalizeCheckpoint() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.discarded) {
                throw new IllegalStateException("pending checkpoint is discarded");
            }
            if (this.notYetAcknowledgedTasks.isEmpty()) {
                CompletedCheckpoint completed = new CompletedCheckpoint(this.jobId, this.checkpointId, this.checkpointTimestamp, System.currentTimeMillis(), new HashMap<JobVertexID, TaskState>(this.taskStates));
                this.dispose(null, false);
                return completed;
            }
            throw new IllegalStateException("Cannot complete checkpoint while not all tasks are acknowledged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acknowledgeTask(ExecutionAttemptID attemptID, SerializedValue<StateHandle<?>> state, long stateSize, Map<Integer, SerializedValue<StateHandle<?>>> kvState) {
        Object object = this.lock;
        synchronized (object) {
            if (this.discarded) {
                return false;
            }
            ExecutionVertex vertex = this.notYetAcknowledgedTasks.remove((Object)attemptID);
            if (vertex != null) {
                if (state != null || kvState != null) {
                    TaskState taskState;
                    JobVertexID jobVertexID = vertex.getJobvertexId();
                    if (this.taskStates.containsKey((Object)jobVertexID)) {
                        taskState = this.taskStates.get((Object)jobVertexID);
                    } else {
                        taskState = new TaskState(jobVertexID, vertex.getTotalNumberOfParallelSubtasks());
                        this.taskStates.put(jobVertexID, taskState);
                    }
                    long timestamp = System.currentTimeMillis() - this.checkpointTimestamp;
                    if (state != null) {
                        taskState.putState(vertex.getParallelSubtaskIndex(), new SubtaskState(state, stateSize, timestamp));
                    }
                    if (kvState != null) {
                        for (Map.Entry<Integer, SerializedValue<StateHandle<?>>> entry : kvState.entrySet()) {
                            taskState.putKvState(entry.getKey(), new KeyGroupState(entry.getValue(), 0L, timestamp));
                        }
                    }
                }
                ++this.numAcknowledgedTasks;
                return true;
            }
            return false;
        }
    }

    public void discard(ClassLoader userClassLoader) throws Exception {
        this.dispose(userClassLoader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(ClassLoader userClassLoader, boolean releaseState) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.discarded = true;
            this.numAcknowledgedTasks = -1;
            try {
                if (releaseState) {
                    for (TaskState taskState : this.taskStates.values()) {
                        taskState.discard(userClassLoader);
                    }
                }
            }
            finally {
                this.taskStates.clear();
                this.notYetAcknowledgedTasks.clear();
            }
        }
    }

    public String toString() {
        return String.format("PendingCheckpoint %d @ %d - confirmed=%d, pending=%d", this.checkpointId, this.checkpointTimestamp, this.getNumberOfAcknowledgedTasks(), this.getNumberOfNonAcknowledgedTasks());
    }
}

