/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyResponseBody;
import org.apache.flink.runtime.rest.messages.JobClientHeartbeatParameters;
import org.apache.flink.runtime.rest.messages.JobClientHeartbeatRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobClientHeartbeatHandler
extends AbstractRestHandler<RestfulGateway, JobClientHeartbeatRequestBody, EmptyResponseBody, JobClientHeartbeatParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(JobClientHeartbeatHandler.class);

    public JobClientHeartbeatHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> headers, MessageHeaders<JobClientHeartbeatRequestBody, EmptyResponseBody, JobClientHeartbeatParameters> messageHeaders) {
        super(leaderRetriever, timeout, headers, messageHeaders);
    }

    @Override
    public CompletableFuture<EmptyResponseBody> handleRequest(HandlerRequest<JobClientHeartbeatRequestBody> request, RestfulGateway gateway) throws RestHandlerException {
        return gateway.reportJobClientHeartbeat((JobID)request.getPathParameter(JobIDPathParameter.class), request.getRequestBody().getExpiredTimestamp(), this.timeout).handle((ack, error) -> {
            if (error != null) {
                String errorMessage = "Fail to report jobClient's heartbeat: " + error.getMessage();
                LOG.error(errorMessage, error);
                throw new CompletionException((Throwable)((Object)new RestHandlerException(errorMessage, HttpResponseStatus.INTERNAL_SERVER_ERROR, (Throwable)error)));
            }
            return EmptyResponseBody.getInstance();
        });
    }
}

