/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.FreeSlotTracker;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;

class EvenlySpreadOutLocationPreferenceSlotSelectionStrategy
extends LocationPreferenceSlotSelectionStrategy {
    EvenlySpreadOutLocationPreferenceSlotSelectionStrategy() {
    }

    @Override
    @Nonnull
    protected Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectWithoutLocationPreference(@Nonnull FreeSlotTracker freeSlotTracker, @Nonnull ResourceProfile resourceProfile) {
        return freeSlotTracker.getAvailableSlots().stream().map(freeSlotTracker::getSlotInfo).filter(slotInfo -> slotInfo.getResourceProfile().isMatching(resourceProfile)).map(slot -> new Tuple2(slot, (Object)freeSlotTracker.getTaskExecutorUtilization((SlotInfo)slot))).min(Comparator.comparingDouble(tuple -> (Double)tuple.f1)).map(slotInfoWithTaskExecutorUtilization -> SlotSelectionStrategy.SlotInfoAndLocality.of((SlotInfo)slotInfoWithTaskExecutorUtilization.f0, Locality.UNCONSTRAINED));
    }

    @Override
    protected double calculateCandidateScore(int localWeigh, int hostLocalWeigh, Supplier<Double> taskExecutorUtilizationSupplier) {
        return (double)(localWeigh * 20 + hostLocalWeigh * 2) - taskExecutorUtilizationSupplier.get();
    }
}

