/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.Collection;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.SchedulerExecutionMode;
import org.apache.flink.core.failure.FailureEnricher;
import org.apache.flink.runtime.dispatcher.JobManagerRunnerFactory;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmaster.DefaultSlotPoolServiceSchedulerFactory;
import org.apache.flink.runtime.jobmaster.JobManagerRunner;
import org.apache.flink.runtime.jobmaster.JobManagerSharedServices;
import org.apache.flink.runtime.jobmaster.JobMasterConfiguration;
import org.apache.flink.runtime.jobmaster.JobMasterServiceLeadershipRunner;
import org.apache.flink.runtime.jobmaster.factories.DefaultJobMasterServiceFactory;
import org.apache.flink.runtime.jobmaster.factories.DefaultJobMasterServiceProcessFactory;
import org.apache.flink.runtime.jobmaster.factories.JobManagerJobMetricGroupFactory;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.MdcUtils;
import org.apache.flink.util.Preconditions;

public enum JobMasterServiceLeadershipRunnerFactory implements JobManagerRunnerFactory
{
    INSTANCE;


    @Override
    public JobManagerRunner createJobManagerRunner(JobGraph jobGraph, Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, JobManagerSharedServices jobManagerServices, JobManagerJobMetricGroupFactory jobManagerJobMetricGroupFactory, FatalErrorHandler fatalErrorHandler, Collection<FailureEnricher> failureEnrichers, long initializationTimestamp) throws Exception {
        Preconditions.checkArgument((jobGraph.getNumberOfVertices() > 0 ? 1 : 0) != 0, (Object)"The given job is empty");
        JobMasterConfiguration jobMasterConfiguration = JobMasterConfiguration.fromConfiguration(configuration);
        JobResultStore jobResultStore = highAvailabilityServices.getJobResultStore();
        LeaderElection jobManagerLeaderElection = highAvailabilityServices.getJobManagerLeaderElection(jobGraph.getJobID());
        DefaultSlotPoolServiceSchedulerFactory slotPoolServiceSchedulerFactory = DefaultSlotPoolServiceSchedulerFactory.fromConfiguration(configuration, jobGraph.getJobType(), jobGraph.isDynamic());
        if (jobMasterConfiguration.getConfiguration().get(JobManagerOptions.SCHEDULER_MODE) == SchedulerExecutionMode.REACTIVE) {
            Preconditions.checkState((slotPoolServiceSchedulerFactory.getSchedulerType() == JobManagerOptions.SchedulerType.Adaptive ? 1 : 0) != 0, (Object)"Adaptive Scheduler is required for reactive mode");
        }
        LibraryCacheManager.ClassLoaderLease classLoaderLease = jobManagerServices.getLibraryCacheManager().registerClassLoaderLease(jobGraph.getJobID());
        ClassLoader userCodeClassLoader = classLoaderLease.getOrResolveClassLoader(jobGraph.getUserJarBlobKeys(), jobGraph.getClasspaths()).asClassLoader();
        DefaultJobMasterServiceFactory jobMasterServiceFactory = new DefaultJobMasterServiceFactory(MdcUtils.scopeToJob((JobID)jobGraph.getJobID(), (Executor)jobManagerServices.getIoExecutor()), rpcService, jobMasterConfiguration, jobGraph, highAvailabilityServices, slotPoolServiceSchedulerFactory, jobManagerServices, heartbeatServices, jobManagerJobMetricGroupFactory, fatalErrorHandler, userCodeClassLoader, failureEnrichers, initializationTimestamp);
        DefaultJobMasterServiceProcessFactory jobMasterServiceProcessFactory = new DefaultJobMasterServiceProcessFactory(jobGraph.getJobID(), jobGraph.getName(), jobGraph.getJobType(), jobGraph.getCheckpointingSettings(), initializationTimestamp, jobMasterServiceFactory);
        return new JobMasterServiceLeadershipRunner(jobMasterServiceProcessFactory, jobManagerLeaderElection, jobResultStore, classLoaderLease, fatalErrorHandler);
    }
}

