/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.guava31.com.google.common.collect.MapDifference;

@Internal
public class ConfigurationNotAllowedMessage {
    private ConfigurationNotAllowedMessage() {
    }

    public static String ofConfigurationAdded(String configKey, String configValue) {
        return String.format("Configuration %s:%s not allowed.", configKey, configValue);
    }

    public static String ofConfigurationRemoved(String configKey, String configValue) {
        return String.format("Configuration %s:%s was removed.", configKey, configValue);
    }

    public static String ofConfigurationChanged(String configKey, MapDifference.ValueDifference<String> change) {
        return String.format("Configuration %s was changed from %s to %s.", configKey, change.leftValue(), change.rightValue());
    }

    public static String ofConfigurationObjectAdded(String configurationObject, String configKey, String configValue) {
        return String.format("Configuration %s:%s not allowed in the configuration object %s.", configKey, configValue, configurationObject);
    }

    public static String ofConfigurationObjectChanged(String configurationObject, String configKey, MapDifference.ValueDifference<String> change) {
        return String.format("Configuration %s was changed from %s to %s in the configuration object %s.", configKey, change.leftValue(), change.rightValue(), configurationObject);
    }

    public static String ofConfigurationObjectRemoved(String configurationObject, String configKey, String configValue) {
        return String.format("Configuration %s:%s was removed from the configuration object %s.", configKey, configValue, configurationObject);
    }

    public static String ofConfigurationObjectSetterUsed(String configurationObject, String setter) {
        return String.format("Setter %s#%s has been used", configurationObject, setter);
    }
}

