/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.storage;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.ConfigurableCheckpointStorage;
import org.apache.flink.runtime.state.filesystem.AbstractFsCheckpointStorageAccess;
import org.apache.flink.runtime.state.memory.MemoryBackendCheckpointStorageAccess;
import org.apache.flink.runtime.state.storage.ExternalizedSnapshotLocation;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TernaryBoolean;

@PublicEvolving
public class JobManagerCheckpointStorage
implements CheckpointStorage,
ConfigurableCheckpointStorage {
    private static final long serialVersionUID = 4109305377809414635L;
    public static final int DEFAULT_MAX_STATE_SIZE = 0x500000;
    private final int maxStateSize;
    private final ExternalizedSnapshotLocation location;
    private TernaryBoolean createCheckpointSubDirs = TernaryBoolean.UNDEFINED;

    public JobManagerCheckpointStorage() {
        this(null, 0x500000);
    }

    public JobManagerCheckpointStorage(int maxStateSize) {
        this(null, maxStateSize);
    }

    public JobManagerCheckpointStorage(String checkpointPath) {
        this(new Path(checkpointPath), 0x500000);
    }

    public JobManagerCheckpointStorage(Path checkpointPath, int maxStateSize) {
        Preconditions.checkArgument((maxStateSize > 0 ? 1 : 0) != 0, (Object)"maxStateSize must be > 0");
        this.maxStateSize = maxStateSize;
        this.location = ExternalizedSnapshotLocation.newBuilder().withCheckpointPath(checkpointPath).build();
    }

    private JobManagerCheckpointStorage(JobManagerCheckpointStorage original, ReadableConfig config) {
        this.maxStateSize = original.maxStateSize;
        this.location = ExternalizedSnapshotLocation.newBuilder().withCheckpointPath(original.location.getBaseCheckpointPath()).withSavepointPath(original.location.getBaseSavepointPath()).withConfiguration(config).build();
        this.createCheckpointSubDirs = original.createCheckpointSubDirs.resolveUndefined(((Boolean)config.get(CheckpointingOptions.CREATE_CHECKPOINT_SUB_DIR)).booleanValue());
    }

    public int getMaxStateSize() {
        return this.maxStateSize;
    }

    @Nullable
    public Path getCheckpointPath() {
        return this.location.getBaseCheckpointPath();
    }

    @Nullable
    public Path getSavepointPath() {
        return this.location.getBaseSavepointPath();
    }

    @Override
    public JobManagerCheckpointStorage configure(ReadableConfig config, ClassLoader classLoader) {
        return new JobManagerCheckpointStorage(this, config);
    }

    public static JobManagerCheckpointStorage createFromConfig(ReadableConfig config, ClassLoader classLoader) throws IllegalConfigurationException {
        try {
            return new JobManagerCheckpointStorage().configure(config, classLoader);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalConfigurationException("Invalid configuration for the state backend", (Throwable)e);
        }
    }

    @Override
    public CompletedCheckpointStorageLocation resolveCheckpoint(String pointer) throws IOException {
        return AbstractFsCheckpointStorageAccess.resolveCheckpointPointer(pointer);
    }

    @Override
    public CheckpointStorageAccess createCheckpointStorage(JobID jobId) throws IOException {
        return new MemoryBackendCheckpointStorageAccess(jobId, this.location.getBaseCheckpointPath(), this.location.getBaseSavepointPath(), this.createCheckpointSubDirs.getOrDefault(((Boolean)CheckpointingOptions.CREATE_CHECKPOINT_SUB_DIR.defaultValue()).booleanValue()), this.maxStateSize);
    }

    public String toString() {
        return "JobManagerCheckpointStorage (checkpoints to JobManager) ( maxStateSize: " + this.maxStateSize + ")";
    }
}

