/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import javax.annotation.Nullable;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.Created;
import org.apache.flink.runtime.scheduler.adaptive.MockStateWithoutExecutionGraphContext;
import org.apache.flink.runtime.scheduler.adaptive.StateValidator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CreatedTest {
    private static final Logger LOG = LoggerFactory.getLogger(CreatedTest.class);
    @RegisterExtension
    MockCreatedContext ctx = new MockCreatedContext();

    CreatedTest() {
    }

    @Test
    void testStartScheduling() {
        Created created = new Created((Created.Context)this.ctx, LOG);
        this.ctx.setExpectWaitingForResources();
        created.startScheduling();
    }

    @Test
    void testJobInformation() {
        Created created = new Created((Created.Context)this.ctx, LOG);
        ArchivedExecutionGraph job = created.getJob();
        Assertions.assertThat((Comparable)job.getState()).isEqualTo((Object)JobStatus.INITIALIZING);
    }

    static class MockCreatedContext
    extends MockStateWithoutExecutionGraphContext
    implements Created.Context {
        private final StateValidator<Void> waitingForResourcesStateValidator = new StateValidator("WaitingForResources");

        MockCreatedContext() {
        }

        public void setExpectWaitingForResources() {
            this.waitingForResourcesStateValidator.expectInput(none -> {});
        }

        public void goToWaitingForResources(@Nullable ExecutionGraph previousExecutionGraph) {
            this.waitingForResourcesStateValidator.validateInput(null);
        }

        @Override
        public void afterEach(ExtensionContext extensionContext) throws Exception {
            super.afterEach(extensionContext);
            this.waitingForResourcesStateValidator.close();
        }
    }
}

