/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class InputChannelIDTest {
    private static final NettyBufferPool ALLOCATOR = new NettyBufferPool(1);

    InputChannelIDTest() {
    }

    @Test
    void testByteBufWriteAndRead() {
        InputChannelID inputChannelID = new InputChannelID();
        int byteBufLen = InputChannelID.getByteBufLength();
        ByteBuf byteBuf = ALLOCATOR.directBuffer(byteBufLen, byteBufLen);
        inputChannelID.writeTo(byteBuf);
        Assertions.assertThat((int)byteBuf.writerIndex()).isEqualTo(InputChannelID.getByteBufLength());
        Assertions.assertThat((Comparable)InputChannelID.fromByteBuf((ByteBuf)byteBuf)).isEqualTo((Object)inputChannelID);
    }
}

