/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.flink.runtime.io.AvailabilityProvider;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.util.function.ThrowingRunnable;
import org.assertj.core.api.Assertions;

public class AvailabilityUtil {
    public static <E extends Throwable> void assertFutureCompletion(boolean after, Supplier<CompletableFuture<?>> futureSupplier, boolean before, ThrowingRunnable<E> runnable) throws E {
        CompletableFuture<?> availableFuture = futureSupplier.get();
        Assertions.assertThat((boolean)availableFuture.isDone()).isEqualTo(before);
        runnable.run();
        Assertions.assertThat((boolean)futureSupplier.get().isDone()).isEqualTo(after);
        if (after) {
            Assertions.assertThat(availableFuture).isDone();
        }
    }

    public static <E extends Throwable> void assertAvailability(AvailabilityProvider availabilityProvider, boolean before, boolean after, ThrowingRunnable<E> runnable) throws E {
        AvailabilityUtil.assertFutureCompletion(after, () -> ((AvailabilityProvider)availabilityProvider).getAvailableFuture(), before, runnable);
    }

    public static <E extends Throwable> void assertPriorityAvailability(InputGate inputGate, boolean before, boolean after, ThrowingRunnable<E> runnable) throws E {
        AvailabilityUtil.assertFutureCompletion(after, () -> ((InputGate)inputGate).getPriorityEventAvailableFuture(), before, runnable);
    }
}

