/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.disk.FileChannelInputView;
import org.apache.flink.runtime.io.disk.FileChannelOutputView;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.types.StringValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FileChannelStreamsTest {
    FileChannelStreamsTest() {
    }

    @Test
    void testCloseAndDeleteOutputView() throws Exception {
        try (IOManagerAsync ioManager = new IOManagerAsync();){
            MemoryManager memMan = MemoryManagerBuilder.newBuilder().build();
            ArrayList memory = new ArrayList();
            memMan.allocatePages((Object)new DummyInvokable(), memory, 4);
            FileIOChannel.ID channel = ioManager.createChannel();
            BlockChannelWriter writer = ioManager.createBlockChannelWriter(channel);
            FileChannelOutputView out = new FileChannelOutputView(writer, memMan, memory, memMan.getPageSize());
            new StringValue((CharSequence)"Some test text").write((DataOutputView)out);
            out.close();
            Assertions.assertThat((boolean)memMan.verifyEmpty()).isTrue();
            out.close();
            out.closeAndDelete();
            Assertions.assertThat((File)new File(channel.getPath())).doesNotExist();
        }
    }

    @Test
    void testCloseAndDeleteInputView() throws Exception {
        try (IOManagerAsync ioManager = new IOManagerAsync();){
            MemoryManager memMan = MemoryManagerBuilder.newBuilder().build();
            ArrayList memory = new ArrayList();
            memMan.allocatePages((Object)new DummyInvokable(), memory, 4);
            FileIOChannel.ID channel = ioManager.createChannel();
            try (FileWriter wrt = new FileWriter(channel.getPath());){
                wrt.write("test data");
            }
            BlockChannelReader reader = ioManager.createBlockChannelReader(channel);
            FileChannelInputView in = new FileChannelInputView(reader, memMan, memory, 9);
            in.readInt();
            in.close();
            Assertions.assertThat((boolean)memMan.verifyEmpty()).isTrue();
            in.close();
            in.closeAndDelete();
            Assertions.assertThat((File)new File(channel.getPath())).doesNotExist();
        }
    }
}

