/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collections;
import java.util.Random;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateHandleDummyUtil;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.StateObject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TaskStateSnapshotTest {
    TaskStateSnapshotTest() {
    }

    @Test
    void putGetSubtaskStateByOperatorID() {
        TaskStateSnapshot taskStateSnapshot = new TaskStateSnapshot();
        OperatorID operatorID_1 = new OperatorID();
        OperatorID operatorID_2 = new OperatorID();
        OperatorSubtaskState operatorSubtaskState_1 = OperatorSubtaskState.builder().build();
        OperatorSubtaskState operatorSubtaskState_2 = OperatorSubtaskState.builder().build();
        OperatorSubtaskState operatorSubtaskState_1_replace = OperatorSubtaskState.builder().build();
        Assertions.assertThat((Object)taskStateSnapshot.getSubtaskStateByOperatorID(operatorID_1)).isNull();
        Assertions.assertThat((Object)taskStateSnapshot.getSubtaskStateByOperatorID(operatorID_2)).isNull();
        taskStateSnapshot.putSubtaskStateByOperatorID(operatorID_1, operatorSubtaskState_1);
        taskStateSnapshot.putSubtaskStateByOperatorID(operatorID_2, operatorSubtaskState_2);
        Assertions.assertThat((Object)taskStateSnapshot.getSubtaskStateByOperatorID(operatorID_1)).isEqualTo((Object)operatorSubtaskState_1);
        Assertions.assertThat((Object)taskStateSnapshot.getSubtaskStateByOperatorID(operatorID_2)).isEqualTo((Object)operatorSubtaskState_2);
        Assertions.assertThat((Object)taskStateSnapshot.putSubtaskStateByOperatorID(operatorID_1, operatorSubtaskState_1_replace)).isEqualTo((Object)operatorSubtaskState_1);
        Assertions.assertThat((Object)taskStateSnapshot.getSubtaskStateByOperatorID(operatorID_1)).isEqualTo((Object)operatorSubtaskState_1_replace);
    }

    @Test
    void hasState() {
        Random random = new Random(66L);
        TaskStateSnapshot taskStateSnapshot = new TaskStateSnapshot();
        Assertions.assertThat((boolean)taskStateSnapshot.hasState()).isFalse();
        OperatorSubtaskState emptyOperatorSubtaskState = OperatorSubtaskState.builder().build();
        Assertions.assertThat((boolean)emptyOperatorSubtaskState.hasState()).isFalse();
        taskStateSnapshot.putSubtaskStateByOperatorID(new OperatorID(), emptyOperatorSubtaskState);
        Assertions.assertThat((boolean)taskStateSnapshot.hasState()).isFalse();
        OperatorStateHandle stateHandle = StateHandleDummyUtil.createNewOperatorStateHandle(2, random);
        OperatorSubtaskState nonEmptyOperatorSubtaskState = OperatorSubtaskState.builder().setManagedOperatorState(stateHandle).build();
        Assertions.assertThat((boolean)nonEmptyOperatorSubtaskState.hasState()).isTrue();
        taskStateSnapshot.putSubtaskStateByOperatorID(new OperatorID(), nonEmptyOperatorSubtaskState);
        Assertions.assertThat((boolean)taskStateSnapshot.hasState()).isTrue();
    }

    @Test
    void discardState() throws Exception {
        TaskStateSnapshot taskStateSnapshot = new TaskStateSnapshot();
        OperatorID operatorID_1 = new OperatorID();
        OperatorID operatorID_2 = new OperatorID();
        OperatorSubtaskState operatorSubtaskState_1 = (OperatorSubtaskState)Mockito.mock(OperatorSubtaskState.class);
        OperatorSubtaskState operatorSubtaskState_2 = (OperatorSubtaskState)Mockito.mock(OperatorSubtaskState.class);
        taskStateSnapshot.putSubtaskStateByOperatorID(operatorID_1, operatorSubtaskState_1);
        taskStateSnapshot.putSubtaskStateByOperatorID(operatorID_2, operatorSubtaskState_2);
        taskStateSnapshot.discardState();
        ((OperatorSubtaskState)Mockito.verify((Object)operatorSubtaskState_1)).discardState();
        ((OperatorSubtaskState)Mockito.verify((Object)operatorSubtaskState_2)).discardState();
    }

    @Test
    void getStateSize() {
        Random random = new Random(66L);
        TaskStateSnapshot taskStateSnapshot = new TaskStateSnapshot();
        Assertions.assertThat((long)taskStateSnapshot.getStateSize()).isZero();
        OperatorSubtaskState emptyOperatorSubtaskState = OperatorSubtaskState.builder().build();
        Assertions.assertThat((boolean)emptyOperatorSubtaskState.hasState()).isFalse();
        taskStateSnapshot.putSubtaskStateByOperatorID(new OperatorID(), emptyOperatorSubtaskState);
        Assertions.assertThat((long)taskStateSnapshot.getStateSize()).isZero();
        OperatorStateHandle stateHandle_1 = StateHandleDummyUtil.createNewOperatorStateHandle(2, random);
        OperatorSubtaskState nonEmptyOperatorSubtaskState_1 = OperatorSubtaskState.builder().setManagedOperatorState(stateHandle_1).build();
        OperatorStateHandle stateHandle_2 = StateHandleDummyUtil.createNewOperatorStateHandle(2, random);
        OperatorSubtaskState nonEmptyOperatorSubtaskState_2 = OperatorSubtaskState.builder().setRawOperatorState(stateHandle_2).build();
        taskStateSnapshot.putSubtaskStateByOperatorID(new OperatorID(), nonEmptyOperatorSubtaskState_1);
        taskStateSnapshot.putSubtaskStateByOperatorID(new OperatorID(), nonEmptyOperatorSubtaskState_2);
        long totalSize = stateHandle_1.getStateSize() + stateHandle_2.getStateSize();
        Assertions.assertThat((long)taskStateSnapshot.getStateSize()).isEqualTo(totalSize);
    }

    @Test
    void testSizeIncludesChannelState() {
        Random random = new Random();
        InputChannelStateHandle inputChannelStateHandle = StateHandleDummyUtil.createNewInputChannelStateHandle(10, random);
        ResultSubpartitionStateHandle resultSubpartitionStateHandle = StateHandleDummyUtil.createNewResultSubpartitionStateHandle(10, random);
        TaskStateSnapshot taskStateSnapshot = new TaskStateSnapshot(Collections.singletonMap(new OperatorID(), OperatorSubtaskState.builder().setInputChannelState(StateObjectCollection.singleton((StateObject)inputChannelStateHandle)).setResultSubpartitionState(StateObjectCollection.singleton((StateObject)resultSubpartitionStateHandle)).build()));
        Assertions.assertThat((long)taskStateSnapshot.getStateSize()).isEqualTo(inputChannelStateHandle.getStateSize() + resultSubpartitionStateHandle.getStateSize());
        Assertions.assertThat((boolean)taskStateSnapshot.hasState()).isTrue();
    }
}

