/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemorySpec;
import org.apache.flink.runtime.metrics.TimerGauge;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.shaded.guava31.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FatalExitExceptionHandler;
import org.apache.flink.util.Preconditions;

public class TieredStorageMemoryManagerImpl
implements TieredStorageMemoryManager {
    private static final int INITIAL_REQUEST_BUFFER_TIMEOUT_FOR_RECLAIMING_MS = 50;
    private static final int MAX_DELAY_TIME_TO_TRIGGER_RECLAIM_BUFFER_MS = 1000;
    private final Map<Object, TieredStorageMemorySpec> tieredMemorySpecs;
    private final List<Runnable> bufferReclaimRequestListeners;
    private final float numTriggerReclaimBuffersRatio;
    private final boolean mayReclaimBuffer;
    private final AtomicInteger numRequestedBuffers;
    private final Map<Object, Integer> numOwnerRequestedBuffers;
    private TimerGauge hardBackpressureTimerGauge = new TimerGauge();
    @Nullable
    private ScheduledExecutorService executor;
    private BufferPool bufferPool;
    private boolean isInitialized;

    public TieredStorageMemoryManagerImpl(float numTriggerReclaimBuffersRatio, boolean mayReclaimBuffer) {
        this.numTriggerReclaimBuffersRatio = numTriggerReclaimBuffersRatio;
        this.mayReclaimBuffer = mayReclaimBuffer;
        this.tieredMemorySpecs = new HashMap<Object, TieredStorageMemorySpec>();
        this.numRequestedBuffers = new AtomicInteger(0);
        this.numOwnerRequestedBuffers = new ConcurrentHashMap<Object, Integer>();
        this.bufferReclaimRequestListeners = new ArrayList<Runnable>();
        this.isInitialized = false;
    }

    @Override
    public void setup(BufferPool bufferPool, List<TieredStorageMemorySpec> storageMemorySpecs) {
        this.bufferPool = bufferPool;
        for (TieredStorageMemorySpec memorySpec : storageMemorySpecs) {
            Preconditions.checkState((!this.tieredMemorySpecs.containsKey(memorySpec.getOwner()) ? 1 : 0) != 0, (Object)"Duplicated memory spec.");
            this.tieredMemorySpecs.put(memorySpec.getOwner(), memorySpec);
        }
        if (this.mayReclaimBuffer) {
            this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("buffer reclaim checker").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)FatalExitExceptionHandler.INSTANCE).build());
        }
        this.isInitialized = true;
    }

    @Override
    public void setMetricGroup(TaskIOMetricGroup metricGroup) {
        this.hardBackpressureTimerGauge = (TimerGauge)Preconditions.checkNotNull((Object)metricGroup.getHardBackPressuredTimePerSecond());
    }

    @Override
    public void listenBufferReclaimRequest(Runnable onBufferReclaimRequest) {
        this.bufferReclaimRequestListeners.add(onBufferReclaimRequest);
    }

    @Override
    public BufferBuilder requestBufferBlocking(Object owner) {
        this.checkIsInitialized();
        this.reclaimBuffersIfNeeded(0L);
        CompletableFuture<Void> requestBufferFuture = new CompletableFuture<Void>();
        this.scheduleCheckRequestBufferFuture(requestBufferFuture, 50L);
        MemorySegment memorySegment = this.bufferPool.requestMemorySegment();
        if (memorySegment == null) {
            try {
                this.hardBackpressureTimerGauge.markStart();
                memorySegment = this.bufferPool.requestMemorySegmentBlocking();
                this.hardBackpressureTimerGauge.markEnd();
            }
            catch (InterruptedException e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
        requestBufferFuture.complete(null);
        this.incNumRequestedBuffer(owner);
        return new BufferBuilder((MemorySegment)Preconditions.checkNotNull((Object)memorySegment), segment -> this.recycleBuffer(owner, segment));
    }

    @Override
    public int getMaxNonReclaimableBuffers(Object owner) {
        this.checkIsInitialized();
        int numBuffersUsedOrReservedForOtherOwners = 0;
        for (Map.Entry<Object, TieredStorageMemorySpec> memorySpecEntry : this.tieredMemorySpecs.entrySet()) {
            Object userOwner = memorySpecEntry.getKey();
            TieredStorageMemorySpec storageMemorySpec = memorySpecEntry.getValue();
            if (userOwner.equals(owner)) continue;
            int numGuaranteed = storageMemorySpec.getNumGuaranteedBuffers();
            int numRequested = this.numOwnerRequestedBuffer(userOwner);
            numBuffersUsedOrReservedForOtherOwners += Math.max(numGuaranteed, numRequested);
        }
        return this.bufferPool.getNumBuffers() - numBuffersUsedOrReservedForOtherOwners;
    }

    @Override
    public int numOwnerRequestedBuffer(Object owner) {
        return this.numOwnerRequestedBuffers.getOrDefault(owner, 0);
    }

    @Override
    public void transferBufferOwnership(Object oldOwner, Object newOwner, Buffer buffer) {
        Preconditions.checkState((boolean)buffer.isBuffer(), (Object)"Only buffer supports transfer ownership.");
        this.decNumRequestedBuffer(oldOwner);
        this.incNumRequestedBuffer(newOwner);
        buffer.setRecycler(memorySegment -> this.recycleBuffer(newOwner, memorySegment));
    }

    @Override
    public void release() {
        Preconditions.checkState((this.numRequestedBuffers.get() == 0 ? 1 : 0) != 0, (Object)"Leaking buffers.");
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new TimeoutException("Timeout for shutting down the buffer reclaim checker executor.");
                }
            }
            catch (Exception e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
    }

    private void scheduleCheckRequestBufferFuture(CompletableFuture<Void> requestBufferFuture, long delayMs) {
        if (!this.mayReclaimBuffer || requestBufferFuture.isDone()) {
            return;
        }
        ((ScheduledExecutorService)Preconditions.checkNotNull((Object)this.executor)).schedule(() -> this.internalCheckRequestBufferFuture(requestBufferFuture, delayMs * 2L), delayMs, TimeUnit.MILLISECONDS);
    }

    private void internalCheckRequestBufferFuture(CompletableFuture<Void> requestBufferFuture, long delayForNextCheckMs) {
        if (requestBufferFuture.isDone()) {
            return;
        }
        this.reclaimBuffersIfNeeded(delayForNextCheckMs);
        this.scheduleCheckRequestBufferFuture(requestBufferFuture, delayForNextCheckMs);
    }

    private void incNumRequestedBuffer(Object owner) {
        this.numOwnerRequestedBuffers.compute(owner, (ignore, numRequested) -> numRequested == null ? 1 : numRequested + 1);
        this.numRequestedBuffers.incrementAndGet();
    }

    private void decNumRequestedBuffer(Object owner) {
        this.numOwnerRequestedBuffers.compute(owner, (ignore, numRequested) -> (Integer)Preconditions.checkNotNull((Object)numRequested) - 1);
        this.numRequestedBuffers.decrementAndGet();
    }

    private void reclaimBuffersIfNeeded(long delayForNextCheckMs) {
        if (this.shouldReclaimBuffersBeforeRequesting(delayForNextCheckMs)) {
            this.bufferReclaimRequestListeners.forEach(Runnable::run);
        }
    }

    private boolean shouldReclaimBuffersBeforeRequesting(long delayForNextCheckMs) {
        int numTotal = this.bufferPool.getNumBuffers();
        int numRequested = this.numRequestedBuffers.get();
        return numRequested >= numTotal || (double)(numRequested + 1) * 1.0 / (double)numTotal > (double)this.numTriggerReclaimBuffersRatio || delayForNextCheckMs > 1000L && this.bufferPool.getNumberOfAvailableMemorySegments() == 0;
    }

    private void recycleBuffer(Object owner, MemorySegment buffer) {
        this.bufferPool.recycle(buffer);
        this.decNumRequestedBuffer(owner);
    }

    private void checkIsInitialized() {
        Preconditions.checkState((boolean)this.isInitialized, (Object)"The memory manager is not in the running state.");
    }
}

