/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import java.util.HashSet;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.util.Preconditions;

public class TaskManagerRegistration {
    private final TaskExecutorConnection taskManagerConnection;
    private final ResourceProfile defaultSlotResourceProfile;
    private final ResourceProfile totalResource;
    private final HashSet<SlotID> slots;
    private int numberFreeSlots;
    private long idleSince;

    public TaskManagerRegistration(TaskExecutorConnection taskManagerConnection, Collection<SlotID> slots, ResourceProfile totalResourceProfile, ResourceProfile defaultSlotResourceProfile) {
        this.taskManagerConnection = (TaskExecutorConnection)Preconditions.checkNotNull((Object)taskManagerConnection, (String)"taskManagerConnection");
        Preconditions.checkNotNull(slots, (String)"slots");
        this.totalResource = (ResourceProfile)Preconditions.checkNotNull((Object)totalResourceProfile);
        this.defaultSlotResourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)defaultSlotResourceProfile);
        this.slots = new HashSet<SlotID>(slots);
        this.numberFreeSlots = slots.size();
        this.idleSince = System.currentTimeMillis();
    }

    public TaskExecutorConnection getTaskManagerConnection() {
        return this.taskManagerConnection;
    }

    public InstanceID getInstanceId() {
        return this.taskManagerConnection.getInstanceID();
    }

    public int getNumberRegisteredSlots() {
        return this.slots.size();
    }

    public int getNumberFreeSlots() {
        return this.numberFreeSlots;
    }

    public ResourceProfile getDefaultSlotResourceProfile() {
        return this.defaultSlotResourceProfile;
    }

    public ResourceProfile getTotalResource() {
        return this.totalResource;
    }

    public void freeSlot() {
        Preconditions.checkState((this.numberFreeSlots < this.slots.size() ? 1 : 0) != 0, (Object)"The number of free slots cannot exceed the number of registered slots. This indicates a bug.");
        ++this.numberFreeSlots;
        if (this.numberFreeSlots == this.getNumberRegisteredSlots() && this.idleSince == Long.MAX_VALUE) {
            this.idleSince = System.currentTimeMillis();
        }
    }

    public void occupySlot() {
        Preconditions.checkState((this.numberFreeSlots > 0 ? 1 : 0) != 0, (Object)"There are no more free slots. This indicates a bug.");
        --this.numberFreeSlots;
        this.idleSince = Long.MAX_VALUE;
    }

    public Iterable<SlotID> getSlots() {
        return this.slots;
    }

    public long getIdleSince() {
        return this.idleSince;
    }

    public boolean isIdle() {
        return this.idleSince != Long.MAX_VALUE;
    }

    public void markUsed() {
        this.idleSince = Long.MAX_VALUE;
    }

    public boolean containsSlot(SlotID slotId) {
        return this.slots.contains(slotId);
    }
}

