/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.KeyedBackendSerializationProxy;
import org.apache.flink.runtime.state.OperatorBackendSerializationProxy;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.RegisteredBroadcastStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredOperatorStateBackendMetaInfo;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoReader;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshotReadersWriters;
import org.junit.Assert;
import org.junit.Test;

public class SerializationProxiesTest {
    @Test
    public void testKeyedBackendSerializationProxyRoundtrip() throws Exception {
        byte[] serialized;
        IntSerializer keySerializer = IntSerializer.INSTANCE;
        LongSerializer namespaceSerializer = LongSerializer.INSTANCE;
        DoubleSerializer stateSerializer = DoubleSerializer.INSTANCE;
        ArrayList<StateMetaInfoSnapshot> stateMetaInfoList = new ArrayList<StateMetaInfoSnapshot>();
        stateMetaInfoList.add(new RegisteredKeyValueStateBackendMetaInfo(StateDescriptor.Type.VALUE, "a", (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot());
        stateMetaInfoList.add(new RegisteredKeyValueStateBackendMetaInfo(StateDescriptor.Type.VALUE, "b", (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot());
        stateMetaInfoList.add(new RegisteredKeyValueStateBackendMetaInfo(StateDescriptor.Type.VALUE, "c", (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot());
        KeyedBackendSerializationProxy serializationProxy = new KeyedBackendSerializationProxy((TypeSerializer)keySerializer, stateMetaInfoList, true);
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            serializationProxy.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        serializationProxy = new KeyedBackendSerializationProxy(Thread.currentThread().getContextClassLoader());
        var8_7 = null;
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            serializationProxy.read((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
        Assert.assertTrue((boolean)serializationProxy.isUsingKeyGroupCompression());
        Assert.assertTrue((boolean)(serializationProxy.getKeySerializerSnapshot() instanceof IntSerializer.IntSerializerSnapshot));
        this.assertEqualStateMetaInfoSnapshotsLists(stateMetaInfoList, serializationProxy.getStateMetaInfoSnapshots());
    }

    @Test
    public void testKeyedStateMetaInfoSerialization() throws Exception {
        byte[] serialized;
        String name = "test";
        LongSerializer namespaceSerializer = LongSerializer.INSTANCE;
        DoubleSerializer stateSerializer = DoubleSerializer.INSTANCE;
        StateMetaInfoSnapshot metaInfo = new RegisteredKeyValueStateBackendMetaInfo(StateDescriptor.Type.VALUE, name, (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer).snapshot();
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            StateMetaInfoSnapshotReadersWriters.getWriter().writeStateMetaInfoSnapshot(metaInfo, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        var7_6 = null;
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            StateMetaInfoReader reader = StateMetaInfoSnapshotReadersWriters.getReader((int)6);
            metaInfo = reader.readStateMetaInfoSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
        Assert.assertEquals((Object)name, (Object)metaInfo.getName());
    }

    @Test
    public void testOperatorBackendSerializationProxyRoundtrip() throws Exception {
        byte[] serialized;
        DoubleSerializer stateSerializer = DoubleSerializer.INSTANCE;
        DoubleSerializer keySerializer = DoubleSerializer.INSTANCE;
        StringSerializer valueSerializer = StringSerializer.INSTANCE;
        ArrayList<StateMetaInfoSnapshot> stateMetaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>();
        stateMetaInfoSnapshots.add(new RegisteredOperatorStateBackendMetaInfo("a", (TypeSerializer)stateSerializer, OperatorStateHandle.Mode.SPLIT_DISTRIBUTE).snapshot());
        stateMetaInfoSnapshots.add(new RegisteredOperatorStateBackendMetaInfo("b", (TypeSerializer)stateSerializer, OperatorStateHandle.Mode.SPLIT_DISTRIBUTE).snapshot());
        stateMetaInfoSnapshots.add(new RegisteredOperatorStateBackendMetaInfo("c", (TypeSerializer)stateSerializer, OperatorStateHandle.Mode.UNION).snapshot());
        ArrayList<StateMetaInfoSnapshot> broadcastStateMetaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>();
        broadcastStateMetaInfoSnapshots.add(new RegisteredBroadcastStateBackendMetaInfo("d", OperatorStateHandle.Mode.BROADCAST, (TypeSerializer)keySerializer, (TypeSerializer)valueSerializer).snapshot());
        broadcastStateMetaInfoSnapshots.add(new RegisteredBroadcastStateBackendMetaInfo("e", OperatorStateHandle.Mode.BROADCAST, (TypeSerializer)valueSerializer, (TypeSerializer)keySerializer).snapshot());
        OperatorBackendSerializationProxy serializationProxy = new OperatorBackendSerializationProxy(stateMetaInfoSnapshots, broadcastStateMetaInfoSnapshots);
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            serializationProxy.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        serializationProxy = new OperatorBackendSerializationProxy(Thread.currentThread().getContextClassLoader());
        var9_8 = null;
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            serializationProxy.read((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
        this.assertEqualStateMetaInfoSnapshotsLists(stateMetaInfoSnapshots, serializationProxy.getOperatorStateMetaInfoSnapshots());
        this.assertEqualStateMetaInfoSnapshotsLists(broadcastStateMetaInfoSnapshots, serializationProxy.getBroadcastStateMetaInfoSnapshots());
    }

    @Test
    public void testOperatorStateMetaInfoSerialization() throws Exception {
        byte[] serialized;
        String name = "test";
        DoubleSerializer stateSerializer = DoubleSerializer.INSTANCE;
        StateMetaInfoSnapshot snapshot = new RegisteredOperatorStateBackendMetaInfo(name, (TypeSerializer)stateSerializer, OperatorStateHandle.Mode.UNION).snapshot();
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            StateMetaInfoSnapshotReadersWriters.getWriter().writeStateMetaInfoSnapshot(snapshot, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        var6_5 = null;
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            StateMetaInfoReader reader = StateMetaInfoSnapshotReadersWriters.getReader((int)6);
            snapshot = reader.readStateMetaInfoSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        RegisteredOperatorStateBackendMetaInfo restoredMetaInfo = new RegisteredOperatorStateBackendMetaInfo(snapshot);
        Assert.assertEquals((Object)name, (Object)restoredMetaInfo.getName());
        Assert.assertEquals((Object)OperatorStateHandle.Mode.UNION, (Object)restoredMetaInfo.getAssignmentMode());
        Assert.assertEquals((Object)stateSerializer, (Object)restoredMetaInfo.getPartitionStateSerializer());
    }

    @Test
    public void testBroadcastStateMetaInfoSerialization() throws Exception {
        byte[] serialized;
        String name = "test";
        DoubleSerializer keySerializer = DoubleSerializer.INSTANCE;
        StringSerializer valueSerializer = StringSerializer.INSTANCE;
        StateMetaInfoSnapshot snapshot = new RegisteredBroadcastStateBackendMetaInfo(name, OperatorStateHandle.Mode.BROADCAST, (TypeSerializer)keySerializer, (TypeSerializer)valueSerializer).snapshot();
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            StateMetaInfoSnapshotReadersWriters.getWriter().writeStateMetaInfoSnapshot(snapshot, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        var7_6 = null;
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            StateMetaInfoReader reader = StateMetaInfoSnapshotReadersWriters.getReader((int)6);
            snapshot = reader.readStateMetaInfoSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
        RegisteredBroadcastStateBackendMetaInfo restoredMetaInfo = new RegisteredBroadcastStateBackendMetaInfo(snapshot);
        Assert.assertEquals((Object)name, (Object)restoredMetaInfo.getName());
        Assert.assertEquals((Object)OperatorStateHandle.Mode.BROADCAST, (Object)restoredMetaInfo.getAssignmentMode());
        Assert.assertEquals((Object)keySerializer, (Object)restoredMetaInfo.getKeySerializer());
        Assert.assertEquals((Object)valueSerializer, (Object)restoredMetaInfo.getValueSerializer());
    }

    @Test
    public void testFixTypeOrder() {
        Assert.assertEquals((long)7L, (long)StateDescriptor.Type.values().length);
        Assert.assertEquals((long)0L, (long)StateDescriptor.Type.UNKNOWN.ordinal());
        Assert.assertEquals((long)1L, (long)StateDescriptor.Type.VALUE.ordinal());
        Assert.assertEquals((long)2L, (long)StateDescriptor.Type.LIST.ordinal());
        Assert.assertEquals((long)3L, (long)StateDescriptor.Type.REDUCING.ordinal());
        Assert.assertEquals((long)4L, (long)StateDescriptor.Type.FOLDING.ordinal());
        Assert.assertEquals((long)5L, (long)StateDescriptor.Type.AGGREGATING.ordinal());
        Assert.assertEquals((long)6L, (long)StateDescriptor.Type.MAP.ordinal());
    }

    private void assertEqualStateMetaInfoSnapshotsLists(List<StateMetaInfoSnapshot> expected, List<StateMetaInfoSnapshot> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            this.assertEqualStateMetaInfoSnapshots(expected.get(i), actual.get(i));
        }
    }

    private void assertEqualStateMetaInfoSnapshots(StateMetaInfoSnapshot expected, StateMetaInfoSnapshot actual) {
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((Object)expected.getBackendStateType(), (Object)actual.getBackendStateType());
        Assert.assertEquals((Object)expected.getOptionsImmutable(), (Object)actual.getOptionsImmutable());
        Assert.assertEquals((Object)expected.getSerializerSnapshotsImmutable(), (Object)actual.getSerializerSnapshotsImmutable());
    }
}

