/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.token;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.core.testutils.ManuallyTriggeredScheduledExecutorService;
import org.apache.flink.runtime.security.token.DefaultDelegationTokenManager;
import org.apache.flink.runtime.security.token.ExceptionThrowingDelegationTokenProvider;
import org.apache.flink.runtime.security.token.ExceptionThrowingDelegationTokenReceiver;
import org.apache.flink.runtime.security.token.TestDelegationTokenProvider;
import org.apache.flink.runtime.security.token.TestDelegationTokenReceiver;
import org.apache.flink.util.concurrent.ManuallyTriggeredScheduledExecutor;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultDelegationTokenManagerTest {
    @BeforeEach
    public void beforeEach() {
        ExceptionThrowingDelegationTokenProvider.reset();
        ExceptionThrowingDelegationTokenReceiver.reset();
    }

    @AfterEach
    public void afterEach() {
        ExceptionThrowingDelegationTokenProvider.reset();
        ExceptionThrowingDelegationTokenReceiver.reset();
    }

    @Test
    public void isProviderEnabledMustGiveBackTrueByDefault() {
        Configuration configuration = new Configuration();
        Assertions.assertTrue((boolean)DefaultDelegationTokenManager.isProviderEnabled((Configuration)configuration, (String)"test"));
    }

    @Test
    public void isProviderEnabledMustGiveBackFalseWhenDisabled() {
        Configuration configuration = new Configuration();
        configuration.setBoolean("security.delegation.token.provider.test.enabled", false);
        Assertions.assertFalse((boolean)DefaultDelegationTokenManager.isProviderEnabled((Configuration)configuration, (String)"test"));
    }

    @Test
    public void configurationIsNullMustFailFast() {
        Assertions.assertThrows(Exception.class, () -> new DefaultDelegationTokenManager(null, null, null, null));
    }

    @Test
    public void oneProviderThrowsExceptionMustFailFast() {
        Assertions.assertThrows(Exception.class, () -> {
            ExceptionThrowingDelegationTokenProvider.throwInInit.set(true);
            new DefaultDelegationTokenManager(new Configuration(), null, null, null);
        });
    }

    @Test
    public void testAllProvidersLoaded() {
        Configuration configuration = new Configuration();
        configuration.setBoolean("security.delegation.token.provider.throw.enabled", false);
        DefaultDelegationTokenManager delegationTokenManager = new DefaultDelegationTokenManager(configuration, null, null, null);
        Assertions.assertEquals((int)3, (int)delegationTokenManager.delegationTokenProviders.size());
        Assertions.assertTrue((boolean)delegationTokenManager.isProviderLoaded("hadoopfs"));
        Assertions.assertTrue((boolean)delegationTokenManager.isReceiverLoaded("hadoopfs"));
        Assertions.assertTrue((boolean)delegationTokenManager.isProviderLoaded("hbase"));
        Assertions.assertTrue((boolean)delegationTokenManager.isReceiverLoaded("hbase"));
        Assertions.assertTrue((boolean)delegationTokenManager.isProviderLoaded("test"));
        Assertions.assertTrue((boolean)delegationTokenManager.isReceiverLoaded("test"));
        Assertions.assertTrue((boolean)ExceptionThrowingDelegationTokenProvider.constructed.get());
        Assertions.assertTrue((boolean)ExceptionThrowingDelegationTokenReceiver.constructed.get());
        Assertions.assertFalse((boolean)delegationTokenManager.isProviderLoaded("throw"));
        Assertions.assertFalse((boolean)delegationTokenManager.isReceiverLoaded("throw"));
    }

    @Test
    public void checkProviderAndReceiverConsistencyShouldNotThrowWhenNothingLoaded() {
        DefaultDelegationTokenManager.checkProviderAndReceiverConsistency(Collections.emptyMap(), Collections.emptyMap());
    }

    @Test
    public void checkProviderAndReceiverConsistencyShouldThrowWhenMissingReceiver() {
        HashMap<String, TestDelegationTokenProvider> providers = new HashMap<String, TestDelegationTokenProvider>();
        providers.put("test", new TestDelegationTokenProvider());
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> DefaultDelegationTokenManager.checkProviderAndReceiverConsistency((Map)providers, Collections.emptyMap()));
        Assertions.assertTrue((boolean)e.getMessage().contains("Missing receivers: test"));
    }

    @Test
    public void checkProviderAndReceiverConsistencyShouldThrowWhenMissingProvider() {
        HashMap<String, TestDelegationTokenReceiver> receivers = new HashMap<String, TestDelegationTokenReceiver>();
        receivers.put("test", new TestDelegationTokenReceiver());
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> DefaultDelegationTokenManager.checkProviderAndReceiverConsistency(Collections.emptyMap(), (Map)receivers));
        Assertions.assertTrue((boolean)e.getMessage().contains("Missing providers: test"));
    }

    @Test
    public void checkProviderAndReceiverConsistencyShouldNotThrowWhenBothLoaded() {
        HashMap<String, TestDelegationTokenProvider> providers = new HashMap<String, TestDelegationTokenProvider>();
        providers.put("test", new TestDelegationTokenProvider());
        HashMap<String, TestDelegationTokenReceiver> receivers = new HashMap<String, TestDelegationTokenReceiver>();
        receivers.put("test", new TestDelegationTokenReceiver());
        DefaultDelegationTokenManager.checkProviderAndReceiverConsistency(providers, receivers);
        Assertions.assertEquals((int)1, (int)providers.size());
        Assertions.assertTrue((boolean)providers.containsKey("test"));
        Assertions.assertEquals((int)1, (int)receivers.size());
        Assertions.assertTrue((boolean)receivers.containsKey("test"));
    }

    @Test
    public void startTokensUpdateShouldScheduleRenewal() {
        ManuallyTriggeredScheduledExecutor scheduledExecutor = new ManuallyTriggeredScheduledExecutor();
        ManuallyTriggeredScheduledExecutorService scheduler = new ManuallyTriggeredScheduledExecutorService();
        ExceptionThrowingDelegationTokenProvider.addToken.set(true);
        Configuration configuration = new Configuration();
        configuration.setBoolean("security.delegation.token.provider.throw.enabled", true);
        final AtomicInteger startTokensUpdateCallCount = new AtomicInteger(0);
        DefaultDelegationTokenManager delegationTokenManager = new DefaultDelegationTokenManager(configuration, null, (ScheduledExecutor)scheduledExecutor, (ExecutorService)scheduler){

            void startTokensUpdate() {
                startTokensUpdateCallCount.incrementAndGet();
                super.startTokensUpdate();
            }
        };
        delegationTokenManager.startTokensUpdate();
        ExceptionThrowingDelegationTokenProvider.throwInUsage.set(true);
        scheduledExecutor.triggerScheduledTasks();
        scheduler.triggerAll();
        ExceptionThrowingDelegationTokenProvider.throwInUsage.set(false);
        scheduledExecutor.triggerScheduledTasks();
        scheduler.triggerAll();
        delegationTokenManager.stopTokensUpdate();
        Assertions.assertEquals((int)3, (int)startTokensUpdateCallCount.get());
    }

    @Test
    public void calculateRenewalDelayShouldConsiderRenewalRatio() {
        Configuration configuration = new Configuration();
        configuration.setBoolean("security.delegation.token.provider.throw.enabled", false);
        configuration.set(SecurityOptions.DELEGATION_TOKENS_RENEWAL_TIME_RATIO, (Object)0.5);
        DefaultDelegationTokenManager delegationTokenManager = new DefaultDelegationTokenManager(configuration, null, null, null);
        Clock constantClock = Clock.fixed(Instant.ofEpochMilli(100L), ZoneId.systemDefault());
        Assertions.assertEquals((long)50L, (long)delegationTokenManager.calculateRenewalDelay(constantClock, 200L));
    }
}

