/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MetricStoreTest {
    private static final JobID JOB_ID = new JobID();

    MetricStoreTest() {
    }

    @Test
    void testAdd() throws IOException {
        MetricStore store = MetricStoreTest.setupStore(new MetricStore());
        Assertions.assertThat((String)store.getJobManagerMetricStore().getMetric("abc.metric1", "-1")).isEqualTo("0");
        Assertions.assertThat((String)store.getTaskManagerMetricStore("tmid").getMetric("abc.metric2", "-1")).isEqualTo("1");
        Assertions.assertThat((String)store.getJobMetricStore(JOB_ID.toString()).getMetric("abc.metric3", "-1")).isEqualTo("2");
        Assertions.assertThat((String)store.getJobMetricStore(JOB_ID.toString()).getMetric("abc.metric4", "-1")).isEqualTo("3");
        Assertions.assertThat((String)store.getTaskMetricStore(JOB_ID.toString(), "taskid").getMetric("8.abc.metric5", "-1")).isEqualTo("14");
        Assertions.assertThat((String)store.getSubtaskMetricStore(JOB_ID.toString(), "taskid", 8).getMetric("abc.metric5", "-1")).isEqualTo("14");
        Assertions.assertThat((String)store.getSubtaskAttemptMetricStore(JOB_ID.toString(), "taskid", 8, 1).getMetric("abc.metric5", "-1")).isEqualTo("4");
        Assertions.assertThat((String)store.getSubtaskAttemptMetricStore(JOB_ID.toString(), "taskid", 8, 2).getMetric("abc.metric5", "-1")).isEqualTo("14");
        Assertions.assertThat((String)store.getTaskMetricStore(JOB_ID.toString(), "taskid").getMetric("8.opname.abc.metric6", "-1")).isEqualTo("5");
        Assertions.assertThat((String)store.getTaskMetricStore(JOB_ID.toString(), "taskid").getMetric("8.opname.abc.metric7", "-1")).isEqualTo("6");
        Assertions.assertThat((String)store.getTaskMetricStore(JOB_ID.toString(), "taskid").getMetric("1.opname.abc.metric7", "-1")).isEqualTo("6");
        Assertions.assertThat((String)store.getSubtaskMetricStore(JOB_ID.toString(), "taskid", 1).getMetric("opname.abc.metric7", "-1")).isEqualTo("6");
        Assertions.assertThat((Object)store.getSubtaskAttemptMetricStore(JOB_ID.toString(), "taskid", 1, 2)).isNull();
        Assertions.assertThat((String)store.getSubtaskAttemptMetricStore(JOB_ID.toString(), "taskid", 1, 3).getMetric("opname.abc.metric7", "-1")).isEqualTo("6");
        Assertions.assertThat((String)store.getSubtaskAttemptMetricStore(JOB_ID.toString(), "taskid", 8, 2).getMetric("opname.abc.metric7", "-1")).isEqualTo("6");
        Assertions.assertThat((String)store.getSubtaskAttemptMetricStore(JOB_ID.toString(), "taskid", 8, 4).getMetric("opname.abc.metric7", "-1")).isEqualTo("16");
    }

    @Test
    void testMalformedNameHandling() {
        MetricStore store = new MetricStore();
        store.add(null);
        QueryScopeInfo.JobManagerQueryScopeInfo info = new QueryScopeInfo.JobManagerQueryScopeInfo("");
        MetricDump.CounterDump cd = new MetricDump.CounterDump((QueryScopeInfo)info, "", 0L);
        store.add((MetricDump)cd);
        Assertions.assertThat((Map)store.getJobManager().metrics).isEmpty();
        Assertions.assertThat((Map)store.getTaskManagers()).isEmpty();
        Assertions.assertThat((Map)store.getJobs()).isEmpty();
    }

    @Test
    void testTaskMetricStoreCleanup() {
        MetricStore store = MetricStoreTest.setupStore(new MetricStore());
        Assertions.assertThat(store.getTaskMetricStore(JOB_ID.toString(), "taskid").getAllSubtaskMetricStores().keySet()).containsExactlyInAnyOrderElementsOf(Arrays.asList(1, 8));
        Map<String, Map<Integer, JobDetails.CurrentAttempts>> currentExecutionAttempts = Collections.singletonMap("taskid", Collections.singletonMap(1, new JobDetails.CurrentAttempts(1, new HashSet())));
        JobDetails jobDetail = new JobDetails(JOB_ID, "jobname", 0L, 0L, 0L, JobStatus.RUNNING, 0L, new int[10], 1, currentExecutionAttempts);
        store.updateCurrentExecutionAttempts(Collections.singleton(jobDetail));
        Assertions.assertThat(store.getTaskMetricStore(JOB_ID.toString(), "taskid").getAllSubtaskMetricStores().keySet()).containsExactlyInAnyOrderElementsOf(Collections.singletonList(1));
    }

    @Test
    void testSubtaskMetricStoreCleanup() {
        MetricStore store = MetricStoreTest.setupStore(new MetricStore());
        Assertions.assertThat(store.getTaskMetricStore(JOB_ID.toString(), "taskid").getSubtaskMetricStore(8).getAllAttemptsMetricStores().keySet()).containsExactlyInAnyOrderElementsOf(Arrays.asList(1, 2, 4, 5));
        HashSet<Integer> currentAttempts = new HashSet<Integer>(Arrays.asList(1, 4));
        Map<String, Map<Integer, JobDetails.CurrentAttempts>> currentExecutionAttempts = Collections.singletonMap("taskid", Collections.singletonMap(8, new JobDetails.CurrentAttempts(1, currentAttempts)));
        JobDetails jobDetail = new JobDetails(JOB_ID, "jobname", 0L, 0L, 0L, JobStatus.RUNNING, 0L, new int[10], 1, currentExecutionAttempts);
        store.updateCurrentExecutionAttempts(Collections.singleton(jobDetail));
        Assertions.assertThat(store.getTaskMetricStore(JOB_ID.toString(), "taskid").getSubtaskMetricStore(8).getAllAttemptsMetricStores().keySet()).containsExactlyInAnyOrderElementsOf(Arrays.asList(1, 4, 5));
    }

    static MetricStore setupStore(MetricStore store) {
        HashMap<Integer, Integer> representativeAttempts = new HashMap<Integer, Integer>();
        representativeAttempts.put(8, 2);
        store.getRepresentativeAttempts().put(JOB_ID.toString(), Collections.singletonMap("taskid", representativeAttempts));
        QueryScopeInfo.JobManagerQueryScopeInfo jm = new QueryScopeInfo.JobManagerQueryScopeInfo("abc");
        MetricDump.CounterDump cd1 = new MetricDump.CounterDump((QueryScopeInfo)jm, "metric1", 0L);
        QueryScopeInfo.TaskManagerQueryScopeInfo tm = new QueryScopeInfo.TaskManagerQueryScopeInfo("tmid", "abc");
        MetricDump.CounterDump cd2 = new MetricDump.CounterDump((QueryScopeInfo)tm, "metric2", 1L);
        MetricDump.CounterDump cd2a = new MetricDump.CounterDump((QueryScopeInfo)tm, "metric22", 1L);
        QueryScopeInfo.TaskManagerQueryScopeInfo tm2 = new QueryScopeInfo.TaskManagerQueryScopeInfo("tmid2", "abc");
        MetricDump.CounterDump cd22 = new MetricDump.CounterDump((QueryScopeInfo)tm2, "metric2", 10L);
        MetricDump.CounterDump cd22a = new MetricDump.CounterDump((QueryScopeInfo)tm2, "metric2b", 10L);
        QueryScopeInfo.JobQueryScopeInfo job = new QueryScopeInfo.JobQueryScopeInfo(JOB_ID.toString(), "abc");
        MetricDump.CounterDump cd3 = new MetricDump.CounterDump((QueryScopeInfo)job, "metric3", 2L);
        MetricDump.CounterDump cd4 = new MetricDump.CounterDump((QueryScopeInfo)job, "metric4", 3L);
        QueryScopeInfo.JobQueryScopeInfo job2 = new QueryScopeInfo.JobQueryScopeInfo("jobid2", "abc");
        MetricDump.CounterDump cd32 = new MetricDump.CounterDump((QueryScopeInfo)job2, "metric3", 2L);
        MetricDump.CounterDump cd42 = new MetricDump.CounterDump((QueryScopeInfo)job2, "metric4", 3L);
        QueryScopeInfo.TaskQueryScopeInfo task = new QueryScopeInfo.TaskQueryScopeInfo(JOB_ID.toString(), "taskid", 8, 1, "abc");
        MetricDump.CounterDump cd5 = new MetricDump.CounterDump((QueryScopeInfo)task, "metric5", 4L);
        QueryScopeInfo.TaskQueryScopeInfo speculativeTask = new QueryScopeInfo.TaskQueryScopeInfo(JOB_ID.toString(), "taskid", 8, 2, "abc");
        MetricDump.CounterDump cd52 = new MetricDump.CounterDump((QueryScopeInfo)speculativeTask, "metric5", 14L);
        QueryScopeInfo.OperatorQueryScopeInfo operator = new QueryScopeInfo.OperatorQueryScopeInfo(JOB_ID.toString(), "taskid", 8, 2, "opname", "abc");
        MetricDump.CounterDump cd6 = new MetricDump.CounterDump((QueryScopeInfo)operator, "metric6", 5L);
        MetricDump.CounterDump cd7 = new MetricDump.CounterDump((QueryScopeInfo)operator, "metric7", 6L);
        QueryScopeInfo.OperatorQueryScopeInfo operator2 = new QueryScopeInfo.OperatorQueryScopeInfo(JOB_ID.toString(), "taskid", 1, 3, "opname", "abc");
        MetricDump.CounterDump cd62 = new MetricDump.CounterDump((QueryScopeInfo)operator2, "metric6", 5L);
        MetricDump.CounterDump cd72 = new MetricDump.CounterDump((QueryScopeInfo)operator2, "metric7", 6L);
        QueryScopeInfo.OperatorQueryScopeInfo speculativeOperator2 = new QueryScopeInfo.OperatorQueryScopeInfo(JOB_ID.toString(), "taskid", 8, 4, "opname", "abc");
        MetricDump.CounterDump cd63 = new MetricDump.CounterDump((QueryScopeInfo)speculativeOperator2, "metric6", 15L);
        MetricDump.CounterDump cd73 = new MetricDump.CounterDump((QueryScopeInfo)speculativeOperator2, "metric7", 16L);
        QueryScopeInfo.OperatorQueryScopeInfo speculativeOperator3 = new QueryScopeInfo.OperatorQueryScopeInfo(JOB_ID.toString(), "taskid", 8, 5, "opname", "abc");
        MetricDump.CounterDump cd64 = new MetricDump.CounterDump((QueryScopeInfo)speculativeOperator3, "metric6", 17L);
        MetricDump.CounterDump cd74 = new MetricDump.CounterDump((QueryScopeInfo)speculativeOperator3, "metric7", 18L);
        store.add((MetricDump)cd1);
        store.add((MetricDump)cd2);
        store.add((MetricDump)cd2a);
        store.add((MetricDump)cd3);
        store.add((MetricDump)cd4);
        store.add((MetricDump)cd5);
        store.add((MetricDump)cd6);
        store.add((MetricDump)cd7);
        store.add((MetricDump)cd62);
        store.add((MetricDump)cd72);
        store.add((MetricDump)cd22);
        store.add((MetricDump)cd22a);
        store.add((MetricDump)cd32);
        store.add((MetricDump)cd42);
        store.add((MetricDump)cd52);
        store.add((MetricDump)cd63);
        store.add((MetricDump)cd73);
        store.add((MetricDump)cd64);
        store.add((MetricDump)cd74);
        return store;
    }
}

