/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.slotmanager.JobScopedResourceTracker;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Assert;
import org.junit.Test;

public class JobScopedResourceTrackerTest
extends TestLogger {
    private static final ResourceProfile PROFILE_1 = ResourceProfile.newBuilder().setCpuCores(1.0).build();
    private static final ResourceProfile PROFILE_2 = ResourceProfile.newBuilder().setCpuCores(2.0).build();

    @Test
    public void testInitialBehavior() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)tracker.getAcquiredResources(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)tracker.getMissingResources(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testLossOfUntrackedResourceThrowsException() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        try {
            tracker.notifyLostResource(ResourceProfile.UNKNOWN);
            Assert.fail((String)"If no resource were acquired, then a loss of resource should fail with an exception.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testIsEmptyForRequirementNotifications() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        tracker.notifyAcquiredResource(ResourceProfile.ANY);
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        tracker.notifyLostResource(ResourceProfile.ANY);
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsEmptyForResourceNotifications() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        tracker.notifyResourceRequirements(Collections.singleton(ResourceRequirement.create((ResourceProfile)ResourceProfile.UNKNOWN, (int)1)));
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        tracker.notifyResourceRequirements(Collections.emptyList());
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testRequirementsNotificationWithoutResources() {
        ResourceRequirement[][] resourceRequirements;
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        for (Object[] objectArray : resourceRequirements = new ResourceRequirement[][]{{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)4), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)2)}, {ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)8), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)2)}, {ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)4), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)2)}}) {
            tracker.notifyResourceRequirements(Arrays.asList(objectArray));
            Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)tracker.getAcquiredResources(), (Matcher)IsEmptyCollection.empty());
            Assert.assertThat((Object)tracker.getMissingResources(), (Matcher)Matchers.containsInAnyOrder((Object[])objectArray));
        }
        tracker.notifyResourceRequirements(Collections.emptyList());
        Assert.assertThat((Object)tracker.getAcquiredResources(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)tracker.getMissingResources(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testRequirementsNotificationWithResources() {
        int x;
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        ResourceRequirement[][] resourceRequirements = new ResourceRequirement[][]{{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)4), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)2)}, {ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)8), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)2)}, {ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)4), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)2)}};
        int numAcquiredSlotsP1 = resourceRequirements[0][0].getNumberOfRequiredSlots() - 1;
        int numAcquiredSlotsP2 = resourceRequirements[0][1].getNumberOfRequiredSlots();
        for (x = 0; x < numAcquiredSlotsP1; ++x) {
            tracker.notifyAcquiredResource(PROFILE_1);
        }
        for (x = 0; x < numAcquiredSlotsP2; ++x) {
            tracker.notifyAcquiredResource(PROFILE_2);
        }
        for (ResourceRequirement[] resourceRequirement : resourceRequirements) {
            tracker.notifyResourceRequirements(Arrays.asList(resourceRequirement));
            Assert.assertThat((Object)tracker.getAcquiredResources(), (Matcher)Matchers.containsInAnyOrder((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)numAcquiredSlotsP1), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)numAcquiredSlotsP2)}));
            Assert.assertThat((Object)tracker.getMissingResources(), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)(resourceRequirement[0].getNumberOfRequiredSlots() - numAcquiredSlotsP1))}));
        }
        tracker.notifyResourceRequirements(Collections.emptyList());
        Assert.assertThat((Object)tracker.getAcquiredResources(), (Matcher)Matchers.containsInAnyOrder((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)numAcquiredSlotsP1), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)numAcquiredSlotsP2)}));
        Assert.assertThat((Object)tracker.getMissingResources(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testMatchingWithResourceExceedingRequirement() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        tracker.notifyResourceRequirements(Arrays.asList(ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)1)));
        tracker.notifyAcquiredResource(PROFILE_2);
        Assert.assertThat((Object)tracker.getAcquiredResources(), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)1)}));
    }

    @Test
    public void testMatchingWithResourceLessThanRequirement() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        tracker.notifyResourceRequirements(Arrays.asList(ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)1)));
        tracker.notifyAcquiredResource(PROFILE_1);
        Assert.assertThat((Object)tracker.getAcquiredResources(), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)1)}));
        Assert.assertThat((Object)tracker.getMissingResources(), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)1)}));
    }

    @Test
    public void testResourceNotificationsWithoutRequirements() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        tracker.notifyAcquiredResource(ResourceProfile.ANY);
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)tracker.getAcquiredResources(), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)}));
        Assert.assertThat((Object)tracker.getMissingResources(), (Matcher)IsEmptyCollection.empty());
        tracker.notifyAcquiredResource(ResourceProfile.ANY);
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)tracker.getAcquiredResources(), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)2)}));
        Assert.assertThat((Object)tracker.getMissingResources(), (Matcher)IsEmptyCollection.empty());
        tracker.notifyLostResource(ResourceProfile.ANY);
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)tracker.getAcquiredResources(), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)}));
        Assert.assertThat((Object)tracker.getMissingResources(), (Matcher)IsEmptyCollection.empty());
        tracker.notifyLostResource(ResourceProfile.ANY);
        Assert.assertThat((Object)tracker.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)tracker.getAcquiredResources(), (Matcher)IsEmptyCollection.empty());
        Assert.assertThat((Object)tracker.getMissingResources(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testResourceNotificationsWithRequirements() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        ResourceRequirement[] resourceRequirementsArray = new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)2), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)1)};
        tracker.notifyResourceRequirements(Arrays.asList(resourceRequirementsArray));
        for (int x = 0; x < 2; ++x) {
            tracker.notifyAcquiredResource(PROFILE_1);
        }
        Assert.assertThat((Object)tracker.getAcquiredResources(), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)2)}));
        Assert.assertThat((Object)tracker.getMissingResources(), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)1)}));
        tracker.notifyLostResource(PROFILE_1);
        Assert.assertThat((Object)tracker.getAcquiredResources(), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)1)}));
        Assert.assertThat((Object)tracker.getMissingResources(), (Matcher)Matchers.containsInAnyOrder((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)PROFILE_1, (int)1), ResourceRequirement.create((ResourceProfile)PROFILE_2, (int)1)}));
    }

    @Test
    public void testRequirementReductionRetainsExceedingResources() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        tracker.notifyResourceRequirements(Collections.singleton(ResourceRequirement.create((ResourceProfile)ResourceProfile.UNKNOWN, (int)1)));
        tracker.notifyAcquiredResource(ResourceProfile.ANY);
        tracker.notifyResourceRequirements(Collections.emptyList());
        Assert.assertThat((Object)tracker.getAcquiredResources(), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)}));
        Assert.assertThat((Object)tracker.getMissingResources(), (Matcher)IsEmptyCollection.empty());
        tracker.notifyResourceRequirements(Collections.singleton(ResourceRequirement.create((ResourceProfile)ResourceProfile.UNKNOWN, (int)1)));
        Assert.assertThat((Object)tracker.getAcquiredResources(), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)}));
        Assert.assertThat((Object)tracker.getMissingResources(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testExcessResourcesAreAssignedOnRequirementIncrease() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        tracker.notifyAcquiredResource(ResourceProfile.ANY);
        tracker.notifyResourceRequirements(Collections.singleton(ResourceRequirement.create((ResourceProfile)ResourceProfile.UNKNOWN, (int)1)));
        Assert.assertThat((Object)tracker.getAcquiredResources(), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)}));
        Assert.assertThat((Object)tracker.getMissingResources(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testExcessResourcesAreAssignedOnResourceLoss() {
        JobScopedResourceTracker tracker = new JobScopedResourceTracker(JobID.generate());
        tracker.notifyAcquiredResource(ResourceProfile.ANY);
        tracker.notifyAcquiredResource(ResourceProfile.ANY);
        tracker.notifyResourceRequirements(Collections.singleton(ResourceRequirement.create((ResourceProfile)ResourceProfile.UNKNOWN, (int)1)));
        tracker.notifyLostResource(ResourceProfile.ANY);
        Assert.assertThat((Object)tracker.getAcquiredResources(), (Matcher)Matchers.contains((Object[])new ResourceRequirement[]{ResourceRequirement.create((ResourceProfile)ResourceProfile.ANY, (int)1)}));
        Assert.assertThat((Object)tracker.getMissingResources(), (Matcher)IsEmptyCollection.empty());
    }
}

