/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.api.common.typeutils.base.IntComparator;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.operators.testutils.types.IntPair;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.Value;
import org.apache.flink.util.MutableObjectIterator;

public final class TestData {
    private static final TupleTypeInfo<Tuple2<Integer, String>> typeInfoIntString = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, String.class});
    private static final TypeSerializerFactory<Tuple2<Integer, String>> serializerFactoryIntString = new MockTupleSerializerFactory<Tuple2<Integer, String>>(typeInfoIntString);
    private static final TupleTypeInfo<Tuple2<Integer, Integer>> typeInfoIntInt = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, Integer.class});
    private static final TypeSerializerFactory<Tuple2<Integer, Integer>> serializerFactoryIntInt = new MockTupleSerializerFactory<Tuple2<Integer, Integer>>(typeInfoIntInt);

    private TestData() {
    }

    public static TupleTypeInfo<Tuple2<Integer, String>> getIntStringTupleTypeInfo() {
        return typeInfoIntString;
    }

    public static TypeSerializerFactory<Tuple2<Integer, String>> getIntStringTupleSerializerFactory() {
        return serializerFactoryIntString;
    }

    public static TypeSerializer<Tuple2<Integer, String>> getIntStringTupleSerializer() {
        return serializerFactoryIntString.getSerializer();
    }

    public static TypeComparator<Tuple2<Integer, String>> getIntStringTupleComparator() {
        return TestData.getIntStringTupleTypeInfo().createComparator(new int[]{0}, new boolean[]{true}, 0, null);
    }

    public static MockTuple2Reader<Tuple2<Integer, String>> getIntStringTupleReader() {
        return new MockTuple2Reader<Tuple2<Integer, String>>();
    }

    public static TupleTypeInfo<Tuple2<Integer, Integer>> getIntIntTupleTypeInfo() {
        return typeInfoIntInt;
    }

    public static TypeSerializerFactory<Tuple2<Integer, Integer>> getIntIntTupleSerializerFactory() {
        return serializerFactoryIntInt;
    }

    public static TypeSerializer<Tuple2<Integer, Integer>> getIntIntTupleSerializer() {
        return TestData.getIntIntTupleSerializerFactory().getSerializer();
    }

    public static TypeComparator<Tuple2<Integer, Integer>> getIntIntTupleComparator() {
        return TestData.getIntIntTupleTypeInfo().createComparator(new int[]{0}, new boolean[]{true}, 0, null);
    }

    public static MockTuple2Reader<Tuple2<Integer, Integer>> getIntIntTupleReader() {
        return new MockTuple2Reader<Tuple2<Integer, Integer>>();
    }

    public static class IntPairComparator
    extends TypeComparator<IntPair> {
        private static final long serialVersionUID = 1L;
        private int reference;
        private final TypeComparator[] comparators = new TypeComparator[]{new IntComparator(true)};

        public int hash(IntPair object) {
            return this.comparators[0].hash((Object)object.getKey());
        }

        public void setReference(IntPair toCompare) {
            this.reference = toCompare.getKey();
        }

        public boolean equalToReference(IntPair candidate) {
            return candidate.getKey() == this.reference;
        }

        public int compareToReference(TypeComparator<IntPair> referencedAccessors) {
            IntPairComparator comp = (IntPairComparator)referencedAccessors;
            return comp.reference - this.reference;
        }

        public int compare(IntPair first, IntPair second) {
            return first.getKey() - second.getKey();
        }

        public int compareSerialized(DataInputView source1, DataInputView source2) throws IOException {
            return source1.readInt() - source2.readInt();
        }

        public boolean supportsNormalizedKey() {
            return true;
        }

        public int getNormalizeKeyLen() {
            return 4;
        }

        public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
            return keyBytes < 4;
        }

        public void putNormalizedKey(IntPair record, MemorySegment target, int offset, int len) {
            block5: {
                int value;
                block4: {
                    value = record.getKey() - Integer.MIN_VALUE;
                    if (len != 4) break block4;
                    target.putIntBigEndian(offset, value);
                    break block5;
                }
                if (len <= 0) break block5;
                if (len < 4) {
                    int i = 0;
                    while (len > 0) {
                        target.put(offset + i, (byte)(value >>> (3 - i << 3) & 0xFF));
                        --len;
                        ++i;
                    }
                } else {
                    target.putIntBigEndian(offset, value);
                    for (int i = 4; i < len; ++i) {
                        target.put(offset + i, (byte)0);
                    }
                }
            }
        }

        public boolean invertNormalizedKey() {
            return false;
        }

        public IntPairComparator duplicate() {
            return new IntPairComparator();
        }

        public int extractKeys(Object record, Object[] target, int index) {
            target[index] = ((IntPair)record).getKey();
            return 1;
        }

        public TypeComparator[] getFlatComparators() {
            return this.comparators;
        }

        public boolean supportsSerializationWithKeyNormalization() {
            return true;
        }

        public void writeWithKeyNormalization(IntPair record, DataOutputView target) throws IOException {
            target.writeInt(record.getKey() - Integer.MIN_VALUE);
            target.writeInt(record.getValue());
        }

        public IntPair readWithKeyDenormalization(IntPair reuse, DataInputView source) throws IOException {
            reuse.setKey(source.readInt() + Integer.MIN_VALUE);
            reuse.setValue(source.readInt());
            return reuse;
        }
    }

    public static class MockTuple2Reader<T extends Tuple2>
    implements MutableObjectIterator<T> {
        private final Tuple2 SENTINEL = new Tuple2();
        private final BlockingQueue<Tuple2> queue;

        public MockTuple2Reader() {
            this.queue = new ArrayBlockingQueue<Tuple2>(32, false);
        }

        public MockTuple2Reader(int size) {
            this.queue = new ArrayBlockingQueue<Tuple2>(size, false);
        }

        public T next(T reuse) {
            Tuple2 r = null;
            while (r == null) {
                try {
                    r = this.queue.take();
                }
                catch (InterruptedException iex) {
                    throw new RuntimeException("Reader was interrupted.");
                }
            }
            if (r.equals((Object)this.SENTINEL)) {
                try {
                    this.queue.put(r);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Reader was interrupted.");
                }
                return null;
            }
            reuse.setField(r.getField(0), 0);
            reuse.setField(r.getField(1), 1);
            return reuse;
        }

        public T next() {
            Tuple2 r = null;
            while (r == null) {
                try {
                    r = this.queue.take();
                }
                catch (InterruptedException iex) {
                    throw new RuntimeException("Reader was interrupted.");
                }
            }
            if (r.equals((Object)this.SENTINEL)) {
                try {
                    this.queue.put(r);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Reader was interrupted.");
                }
                return null;
            }
            Tuple2 result = new Tuple2(r.f0, r.f1);
            return (T)result;
        }

        public void emit(Tuple2 element) throws InterruptedException {
            this.queue.put(new Tuple2(element.f0, element.f1));
        }

        public void close() {
            try {
                this.queue.put(this.SENTINEL);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class MockTupleSerializerFactory<T extends Tuple>
    implements TypeSerializerFactory<T> {
        private final TupleTypeInfo<T> info;

        public MockTupleSerializerFactory(TupleTypeInfo<T> info) {
            this.info = info;
        }

        public void writeParametersToConfig(Configuration config) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void readParametersFromConfig(Configuration config, ClassLoader cl) throws ClassNotFoundException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public TypeSerializer<T> getSerializer() {
            return this.info.createSerializer(null);
        }

        public Class<T> getDataType() {
            return this.info.getTypeClass();
        }
    }

    public static final class ConstantIntIntTuplesIterator
    implements MutableObjectIterator<Tuple2<Integer, Integer>> {
        private final int key;
        private final int value;
        private int numLeft;

        public ConstantIntIntTuplesIterator(int key, int value, int count) {
            this.key = key;
            this.value = value;
            this.numLeft = count;
        }

        public Tuple2<Integer, Integer> next(Tuple2<Integer, Integer> reuse) {
            if (this.numLeft > 0) {
                --this.numLeft;
                reuse.setField((Object)this.key, 0);
                reuse.setField((Object)this.value, 1);
                return reuse;
            }
            return null;
        }

        public Tuple2<Integer, Integer> next() {
            return this.next((Tuple2<Integer, Integer>)new Tuple2((Object)0, (Object)0));
        }
    }

    public static class TupleConstantValueIterator
    implements MutableObjectIterator<Tuple2<Integer, String>> {
        private int key;
        private String value;
        private final String valueValue;
        private final int numPairs;
        private int pos;

        public TupleConstantValueIterator(int keyValue, String valueValue, int numPairs) {
            this.key = keyValue;
            this.valueValue = valueValue;
            this.numPairs = numPairs;
        }

        public Tuple2<Integer, String> next(Tuple2<Integer, String> reuse) {
            if (this.pos < this.numPairs) {
                this.value = this.valueValue + ' ' + this.pos;
                reuse.setFields((Object)this.key, (Object)this.value);
                ++this.pos;
                return reuse;
            }
            return null;
        }

        public Tuple2<Integer, String> next() {
            return this.next((Tuple2<Integer, String>)new Tuple2());
        }

        public void reset() {
            this.pos = 0;
        }
    }

    public static class TupleGeneratorIterator
    implements MutableObjectIterator<Tuple2<Integer, String>> {
        private final TupleGenerator generator;
        private final int numberOfRecords;
        private int counter;

        public TupleGeneratorIterator(TupleGenerator generator, int numberOfRecords) {
            this.generator = generator;
            this.generator.reset();
            this.numberOfRecords = numberOfRecords;
            this.counter = 0;
        }

        public Tuple2<Integer, String> next(Tuple2<Integer, String> target) {
            if (this.counter < this.numberOfRecords) {
                ++this.counter;
                return this.generator.next(target);
            }
            return null;
        }

        public Tuple2<Integer, String> next() {
            if (this.counter < this.numberOfRecords) {
                ++this.counter;
                return this.generator.next();
            }
            return null;
        }

        public void reset() {
            this.counter = 0;
        }
    }

    public static class TupleGenerator
    implements MutableObjectIterator<Tuple2<Integer, String>> {
        private static char[] alpha = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm'};
        private final long seed;
        private final int keyMax;
        private final float keyDensity;
        private final int valueLength;
        private final KeyMode keyMode;
        private final ValueMode valueMode;
        private Random random;
        private int counter;
        private int key;
        private String value;

        public TupleGenerator(long seed, int keyMax, int valueLength) {
            this(seed, keyMax, valueLength, KeyMode.RANDOM, ValueMode.FIX_LENGTH);
        }

        public TupleGenerator(long seed, int keyMax, int valueLength, KeyMode keyMode, ValueMode valueMode) {
            this(seed, keyMax, valueLength, keyMode, valueMode, null);
        }

        public TupleGenerator(long seed, int keyMax, int valueLength, KeyMode keyMode, ValueMode valueMode, String constant) {
            this(seed, keyMax, 1.0f, valueLength, keyMode, valueMode, constant);
        }

        public TupleGenerator(long seed, int keyMax, float keyDensity, int valueLength, KeyMode keyMode, ValueMode valueMode, String constant) {
            this.seed = seed;
            this.keyMax = keyMax;
            this.keyDensity = keyDensity;
            this.valueLength = valueLength;
            this.keyMode = keyMode;
            this.valueMode = valueMode;
            this.random = new Random(seed);
            this.counter = 0;
            this.value = constant == null ? null : constant;
        }

        public Tuple2<Integer, String> next(Tuple2<Integer, String> reuse) {
            this.key = this.nextKey();
            if (this.valueMode != ValueMode.CONSTANT) {
                this.value = this.randomString();
            }
            reuse.setFields((Object)this.key, (Object)this.value);
            return reuse;
        }

        public Tuple2<Integer, String> next() {
            return this.next((Tuple2<Integer, String>)new Tuple2());
        }

        public boolean next(Value[] target) {
            this.key = this.nextKey();
            ((IntValue)target[0]).setValue(this.key);
            ((IntValue)target[1]).setValue(this.random.nextInt());
            return true;
        }

        private int nextKey() {
            if (this.keyMode == KeyMode.SORTED) {
                return ++this.counter;
            }
            if (this.keyMode == KeyMode.SORTED_SPARSE) {
                int max = (int)(1.0f / this.keyDensity);
                this.counter += this.random.nextInt(max) + 1;
                return this.counter;
            }
            return Math.abs(this.random.nextInt() % this.keyMax) + 1;
        }

        public void reset() {
            this.random = new Random(this.seed);
            this.counter = 0;
        }

        private String randomString() {
            int length = this.valueMode == ValueMode.FIX_LENGTH ? this.valueLength : this.valueLength - this.random.nextInt(this.valueLength / 3);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                sb.append(alpha[this.random.nextInt(alpha.length)]);
            }
            return sb.toString();
        }

        public static enum ValueMode {
            FIX_LENGTH,
            RANDOM_LENGTH,
            CONSTANT;

        }

        public static enum KeyMode {
            SORTED,
            RANDOM,
            SORTED_SPARSE;

        }
    }
}

