/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.MetricRegistryTestUtils;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.InternalOperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskMetricGroupTest
extends TestLogger {
    private MetricRegistryImpl registry;

    @Before
    public void setup() {
        this.registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
    }

    @After
    public void teardown() throws Exception {
        if (this.registry != null) {
            this.registry.closeAsync().get();
        }
    }

    @Test
    public void testGenerateScopeDefault() {
        TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"theHostName", (ResourceID)new ResourceID("test-tm-id"));
        TaskMetricGroup taskGroup = tmGroup.addJob(new JobID(), "myJobName").addTask(ExecutionGraphTestUtils.createExecutionAttemptId(new JobVertexID(), 13, 2), "aTaskName");
        Assert.assertArrayEquals((Object[])new String[]{"theHostName", "taskmanager", "test-tm-id", "myJobName", "aTaskName", "13"}, (Object[])taskGroup.getScopeComponents());
        Assert.assertEquals((Object)"theHostName.taskmanager.test-tm-id.myJobName.aTaskName.13.name", (Object)taskGroup.getMetricIdentifier("name"));
    }

    @Test
    public void testGenerateScopeCustom() throws Exception {
        Configuration cfg = new Configuration();
        cfg.setString(MetricOptions.SCOPE_NAMING_TM, "abc");
        cfg.setString(MetricOptions.SCOPE_NAMING_TM_JOB, "def");
        cfg.setString(MetricOptions.SCOPE_NAMING_TASK, "<tm_id>.<job_id>.<task_id>.<task_attempt_id>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        JobID jid = new JobID();
        JobVertexID vertexId = new JobVertexID();
        ExecutionAttemptID executionId = ExecutionGraphTestUtils.createExecutionAttemptId(vertexId, 13, 2);
        TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"theHostName", (ResourceID)new ResourceID("test-tm-id"));
        TaskMetricGroup taskGroup = tmGroup.addJob(jid, "myJobName").addTask(executionId, "aTaskName");
        Assert.assertArrayEquals((Object[])new String[]{"test-tm-id", jid.toString(), vertexId.toString(), executionId.toString()}, (Object[])taskGroup.getScopeComponents());
        Assert.assertEquals((Object)String.format("test-tm-id.%s.%s.%s.name", jid, vertexId, executionId), (Object)taskGroup.getMetricIdentifier("name"));
        registry.closeAsync().get();
    }

    @Test
    public void testGenerateScopeWilcard() throws Exception {
        Configuration cfg = new Configuration();
        cfg.setString(MetricOptions.SCOPE_NAMING_TASK, "*.<task_attempt_id>.<subtask_index>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        ExecutionAttemptID executionId = ExecutionGraphTestUtils.createExecutionAttemptId(new JobVertexID(), 13, 1);
        TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"theHostName", (ResourceID)new ResourceID("test-tm-id"));
        TaskMetricGroup taskGroup = tmGroup.addJob(new JobID(), "myJobName").addTask(executionId, "aTaskName");
        Assert.assertArrayEquals((Object[])new String[]{"theHostName", "taskmanager", "test-tm-id", "myJobName", executionId.toString(), "13"}, (Object[])taskGroup.getScopeComponents());
        Assert.assertEquals((Object)("theHostName.taskmanager.test-tm-id.myJobName." + executionId + ".13.name"), (Object)taskGroup.getMetricIdentifier("name"));
        registry.closeAsync().get();
    }

    @Test
    public void testCreateQueryServiceMetricInfo() {
        JobID jid = new JobID();
        JobVertexID vid = new JobVertexID();
        ExecutionAttemptID eid = ExecutionGraphTestUtils.createExecutionAttemptId(vid, 4, 5);
        TaskManagerMetricGroup tm = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"host", (ResourceID)new ResourceID("id"));
        TaskMetricGroup task = tm.addJob(jid, "jobname").addTask(eid, "taskName");
        QueryScopeInfo.TaskQueryScopeInfo info = task.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assert.assertEquals((Object)"", (Object)info.scope);
        Assert.assertEquals((Object)jid.toString(), (Object)info.jobID);
        Assert.assertEquals((Object)vid.toString(), (Object)info.vertexID);
        Assert.assertEquals((long)4L, (long)info.subtaskIndex);
    }

    @Test
    public void testTaskMetricGroupCleanup() throws Exception {
        CountingMetricRegistry registry = new CountingMetricRegistry(new Configuration());
        TaskManagerMetricGroup taskManagerMetricGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"localhost", (ResourceID)new ResourceID("0"));
        int initialMetricsCount = registry.getNumberRegisteredMetrics();
        TaskMetricGroup taskMetricGroup = taskManagerMetricGroup.addJob(new JobID(), "job").addTask(ExecutionGraphTestUtils.createExecutionAttemptId(), "task");
        Assert.assertTrue((registry.getNumberRegisteredMetrics() > initialMetricsCount ? 1 : 0) != 0);
        taskMetricGroup.close();
        Assert.assertEquals((long)initialMetricsCount, (long)registry.getNumberRegisteredMetrics());
        registry.closeAsync().get();
    }

    @Test
    public void testOperatorNameTruncation() throws Exception {
        Configuration cfg = new Configuration();
        cfg.setString(MetricOptions.SCOPE_NAMING_OPERATOR, ScopeFormat.SCOPE_OPERATOR_NAME);
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        TaskManagerMetricGroup tm = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"host", (ResourceID)new ResourceID("id"));
        TaskMetricGroup taskMetricGroup = tm.addJob(new JobID(), "jobname").addTask(ExecutionGraphTestUtils.createExecutionAttemptId(), "task");
        String originalName = new String(new char[100]).replace("\u0000", "-");
        InternalOperatorMetricGroup operatorMetricGroup = taskMetricGroup.getOrAddOperator(originalName);
        String storedName = operatorMetricGroup.getScopeComponents()[0];
        Assert.assertEquals((long)80L, (long)storedName.length());
        Assert.assertEquals((Object)originalName.substring(0, 80), (Object)storedName);
        registry.closeAsync().get();
    }

    private static class CountingMetricRegistry
    extends MetricRegistryImpl {
        private int counter = 0;

        CountingMetricRegistry(Configuration config) {
            super(MetricRegistryTestUtils.fromConfiguration(config));
        }

        public void register(Metric metric, String metricName, AbstractMetricGroup group) {
            super.register(metric, metricName, group);
            ++this.counter;
        }

        public void unregister(Metric metric, String metricName, AbstractMetricGroup group) {
            super.unregister(metric, metricName, group);
            --this.counter;
        }

        int getNumberRegisteredMetrics() {
            return this.counter;
        }
    }
}

