/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.UnpooledBufferPool;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionBuilder;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.SupplierWithException;
import org.junit.Assert;
import org.junit.Test;

public class PipelinedResultPartitionReleaseOnConsumptionTest
extends TestLogger {
    @Test
    public void testConsumptionBasedPartitionRelease() {
        ResultPartitionManager manager = new ResultPartitionManager();
        ResultPartition partition = new ResultPartitionBuilder().setResultPartitionType(ResultPartitionType.PIPELINED).setNumberOfSubpartitions(2).setResultPartitionManager(manager).build();
        manager.registerResultPartition(partition);
        partition.onConsumedSubpartition(0);
        Assert.assertFalse((boolean)partition.isReleased());
        partition.onConsumedSubpartition(1);
        partition.close();
        Assert.assertTrue((boolean)partition.isReleased());
    }

    @Test
    public void testConsumptionBeforePartitionClose() throws IOException {
        ResultPartition partition = new ResultPartitionBuilder().setResultPartitionType(ResultPartitionType.PIPELINED).setNumberOfSubpartitions(1).setBufferPoolFactory((SupplierWithException<BufferPool, IOException>)((SupplierWithException)UnpooledBufferPool::new)).build();
        partition.setup();
        partition.emitRecord(ByteBuffer.allocate(16), 0);
        partition.onConsumedSubpartition(0);
        Assert.assertFalse((boolean)partition.isReleased());
        partition.emitRecord(ByteBuffer.allocate(16), 0);
        partition.close();
        Assert.assertTrue((boolean)partition.isReleased());
    }

    @Test
    public void testMultipleReleaseCallsAreIdempotent() {
        ResultPartitionManager manager = new ResultPartitionManager();
        ResultPartition partition = new ResultPartitionBuilder().setResultPartitionType(ResultPartitionType.PIPELINED).setNumberOfSubpartitions(2).setResultPartitionManager(manager).build();
        manager.registerResultPartition(partition);
        partition.onConsumedSubpartition(0);
        partition.onConsumedSubpartition(0);
        Assert.assertFalse((boolean)partition.isReleased());
    }

    @Test
    public void testReleaseAfterIdempotentCalls() {
        ResultPartitionManager manager = new ResultPartitionManager();
        ResultPartition partition = new ResultPartitionBuilder().setResultPartitionType(ResultPartitionType.PIPELINED).setNumberOfSubpartitions(2).setResultPartitionManager(manager).build();
        manager.registerResultPartition(partition);
        partition.onConsumedSubpartition(0);
        partition.onConsumedSubpartition(0);
        partition.onConsumedSubpartition(1);
        partition.close();
        Assert.assertTrue((boolean)partition.isReleased());
    }
}

