/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class NettyBufferPoolTest {
    private final List<ByteBuf> needReleasing = new ArrayList<ByteBuf>();

    @After
    public void tearDown() {
        try {
            for (ByteBuf buf : this.needReleasing) {
                buf.release();
            }
            for (ByteBuf buf : this.needReleasing) {
                Assert.assertEquals((long)0L, (long)buf.refCnt());
            }
        }
        finally {
            this.needReleasing.clear();
        }
    }

    @Test
    public void testNoHeapAllocations() throws Exception {
        NettyBufferPool nettyBufferPool = new NettyBufferPool(1);
        Assert.assertTrue((boolean)this.releaseLater(nettyBufferPool.buffer()).isDirect());
        Assert.assertTrue((boolean)this.releaseLater(nettyBufferPool.buffer(128)).isDirect());
        Assert.assertTrue((boolean)this.releaseLater(nettyBufferPool.buffer(128, 256)).isDirect());
        Assert.assertTrue((boolean)this.releaseLater(nettyBufferPool.ioBuffer()).isDirect());
        Assert.assertTrue((boolean)this.releaseLater(nettyBufferPool.ioBuffer(128)).isDirect());
        Assert.assertTrue((boolean)this.releaseLater(nettyBufferPool.ioBuffer(128, 256)).isDirect());
        Assert.assertTrue((boolean)this.releaseLater(nettyBufferPool.heapBuffer()).isDirect());
        Assert.assertTrue((boolean)this.releaseLater(nettyBufferPool.heapBuffer(128)).isDirect());
        Assert.assertTrue((boolean)this.releaseLater(nettyBufferPool.heapBuffer(128, 256)).isDirect());
        Assert.assertTrue((boolean)this.releaseLater((ByteBuf)nettyBufferPool.compositeHeapBuffer()).capacity(1024).isDirect());
        Assert.assertTrue((boolean)this.releaseLater((ByteBuf)nettyBufferPool.compositeHeapBuffer(10)).capacity(1024).isDirect());
        Assert.assertTrue((boolean)nettyBufferPool.isDirectBufferPooled());
    }

    @Test
    public void testAllocationsStatistics() throws Exception {
        NettyBufferPool nettyBufferPool = new NettyBufferPool(1);
        int chunkSize = nettyBufferPool.getChunkSize();
        this.releaseLater(nettyBufferPool.directBuffer(chunkSize - 64));
        long allocated = (Long)nettyBufferPool.getNumberOfAllocatedBytes().get();
        Assert.assertEquals((long)chunkSize, (long)allocated);
        this.releaseLater(nettyBufferPool.directBuffer(128));
        allocated = (Long)nettyBufferPool.getNumberOfAllocatedBytes().get();
        Assert.assertEquals((long)(2 * chunkSize), (long)allocated);
    }

    private ByteBuf releaseLater(ByteBuf buf) {
        this.needReleasing.add(buf);
        return buf;
    }
}

