/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.util.TestingUserCodeClassLoader;
import org.apache.flink.util.UserCodeClassLoader;
import org.apache.flink.util.function.BiFunctionWithException;

public class TestingClassLoaderLease
implements LibraryCacheManager.ClassLoaderLease {
    private final BiFunctionWithException<Collection<PermanentBlobKey>, Collection<URL>, UserCodeClassLoader, IOException> getOrResolveClassLoaderFunction;
    private final Runnable closeRunnable;

    public TestingClassLoaderLease(BiFunctionWithException<Collection<PermanentBlobKey>, Collection<URL>, UserCodeClassLoader, IOException> getOrResolveClassLoaderFunction, Runnable closeRunnable) {
        this.getOrResolveClassLoaderFunction = getOrResolveClassLoaderFunction;
        this.closeRunnable = closeRunnable;
    }

    public UserCodeClassLoader getOrResolveClassLoader(Collection<PermanentBlobKey> requiredJarFiles, Collection<URL> requiredClasspaths) throws IOException {
        return (UserCodeClassLoader)this.getOrResolveClassLoaderFunction.apply(requiredJarFiles, requiredClasspaths);
    }

    public void release() {
        this.closeRunnable.run();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private final TestingUserCodeClassLoader userCodeClassLoader = TestingUserCodeClassLoader.newBuilder().build();
        private BiFunctionWithException<Collection<PermanentBlobKey>, Collection<URL>, UserCodeClassLoader, IOException> getOrResolveClassLoaderFunction = (ignoredA, ignoredB) -> this.userCodeClassLoader;
        private Runnable closeRunnable = () -> {};

        private Builder() {
        }

        public Builder setGetOrResolveClassLoaderFunction(BiFunctionWithException<Collection<PermanentBlobKey>, Collection<URL>, UserCodeClassLoader, IOException> getOrResolveClassLoaderFunction) {
            this.getOrResolveClassLoaderFunction = getOrResolveClassLoaderFunction;
            return this;
        }

        public Builder setCloseRunnable(Runnable closeRunnable) {
            this.closeRunnable = closeRunnable;
            return this;
        }

        public TestingClassLoaderLease build() {
            return new TestingClassLoaderLease(this.getOrResolveClassLoaderFunction, this.closeRunnable);
        }
    }
}

