/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.util.Arrays;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.MockChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.shaded.guava30.com.google.common.collect.LinkedListMultimap;
import org.apache.flink.shaded.guava30.com.google.common.collect.ListMultimap;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.ExceptionUtils;

public class RecordingChannelStateWriter
extends MockChannelStateWriter {
    private long lastStartedCheckpointId = -1L;
    private final ListMultimap<InputChannelInfo, Buffer> addedInput = LinkedListMultimap.create();
    private final ListMultimap<ResultSubpartitionInfo, Buffer> addedOutput = LinkedListMultimap.create();

    public RecordingChannelStateWriter() {
        super(false);
    }

    public void reset() {
        this.lastStartedCheckpointId = -1L;
        this.addedInput.values().forEach(Buffer::recycleBuffer);
        this.addedInput.clear();
        this.addedOutput.values().forEach(Buffer::recycleBuffer);
        this.addedOutput.clear();
    }

    @Override
    public void start(long checkpointId, CheckpointOptions checkpointOptions) {
        super.start(checkpointId, checkpointOptions);
        this.lastStartedCheckpointId = checkpointId;
    }

    @Override
    public void addInputData(long checkpointId, InputChannelInfo info, int startSeqNum, CloseableIterator<Buffer> iterator) {
        this.checkCheckpointId(checkpointId);
        iterator.forEachRemaining(b -> this.addedInput.put((Object)info, b));
        try {
            iterator.close();
        }
        catch (Exception e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    @Override
    public void addOutputData(long checkpointId, ResultSubpartitionInfo info, int startSeqNum, Buffer ... data) {
        this.checkCheckpointId(checkpointId);
        this.addedOutput.putAll((Object)info, Arrays.asList(data));
    }

    public long getLastStartedCheckpointId() {
        return this.lastStartedCheckpointId;
    }

    public ListMultimap<InputChannelInfo, Buffer> getAddedInput() {
        return this.addedInput;
    }

    public ListMultimap<ResultSubpartitionInfo, Buffer> getAddedOutput() {
        return this.addedOutput;
    }
}

