/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.blob.PermanentBlobKey;

public class TestingBlobWriter
implements BlobWriter {
    private final Map<Tuple2<JobID, PermanentBlobKey>, byte[]> blobs = new HashMap<Tuple2<JobID, PermanentBlobKey>, byte[]>();
    private int minOffloadingSize;

    public TestingBlobWriter() {
        this(0);
    }

    public TestingBlobWriter(int minOffloadingSize) {
        this.minOffloadingSize = minOffloadingSize;
    }

    public PermanentBlobKey putPermanent(JobID jobId, byte[] value) throws IOException {
        PermanentBlobKey blobKey = new PermanentBlobKey();
        Tuple2 tupleKey = Tuple2.of((Object)jobId, (Object)blobKey);
        if (this.blobs.containsKey(tupleKey)) {
            throw new IllegalStateException("Duplicated key found in in memory blob");
        }
        this.blobs.put((Tuple2<JobID, PermanentBlobKey>)tupleKey, value);
        return blobKey;
    }

    public PermanentBlobKey putPermanent(JobID jobId, InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
                baos.write(buffer, 0, length);
            }
            PermanentBlobKey permanentBlobKey = this.putPermanent(jobId, baos.toByteArray());
            return permanentBlobKey;
        }
    }

    public boolean deletePermanent(JobID jobId, PermanentBlobKey blobKey) {
        return this.blobs.remove(Tuple2.of((Object)jobId, (Object)blobKey)) != null;
    }

    public int getMinOffloadingSize() {
        return this.minOffloadingSize;
    }

    public void setMinOffloadingSize(int minOffloadingSize) {
        this.minOffloadingSize = minOffloadingSize;
    }

    public byte[] getBlob(JobID jobId, PermanentBlobKey blobKey) {
        return this.blobs.get(Tuple2.of((Object)jobId, (Object)blobKey));
    }

    public int numberOfBlobs() {
        return this.blobs.size();
    }
}

