/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.TransientBlobKey;

public class TestingBlobUtils {
    private TestingBlobUtils() {
        throw new UnsupportedOperationException(String.format("Cannot instantiate %s.", TestingBlobUtils.class.getSimpleName()));
    }

    @Nonnull
    static TransientBlobKey writeTransientBlob(Path storageDirectory, JobID jobId, byte[] fileContent) throws IOException {
        return (TransientBlobKey)TestingBlobUtils.writeBlob(storageDirectory, jobId, fileContent, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Nonnull
    static PermanentBlobKey writePermanentBlob(Path storageDirectory, JobID jobId, byte[] fileContent) throws IOException {
        return (PermanentBlobKey)TestingBlobUtils.writeBlob(storageDirectory, jobId, fileContent, BlobKey.BlobType.PERMANENT_BLOB);
    }

    @Nonnull
    static BlobKey writeBlob(Path storageDirectory, JobID jobId, byte[] fileContent, BlobKey.BlobType blobType) throws IOException {
        BlobKey blobKey = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])BlobUtils.createMessageDigest().digest(fileContent));
        File storageLocation = new File(BlobUtils.getStorageLocationPath((String)storageDirectory.toString(), (JobID)jobId, (BlobKey)blobKey));
        FileUtils.createParentDirectories((File)storageLocation);
        FileUtils.writeByteArrayToFile((File)storageLocation, (byte[])fileContent);
        return blobKey;
    }
}

